/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.config;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;

public class SystemConfigForm
extends BaseValidatorForm {
    private String baseUrl = "";
    private String agentMaxQuietTimeAllowed = "";
    private String agentMaxQuietTimeAllowedVal = "0";
    private boolean enableAgentAutoUpdate = false;
    private boolean enableDebugMode = false;
    private String helpUserId = "";
    private String helpPassword = "";
    private String maintIntervalVal = "0";
    private String maintInterval = "";
    private String rtPurgeVal = "0";
    private String rtPurge = "";
    private String alertPurgeVal = "0";
    private String alertPurge = "";
    private String eventPurgeVal = "0";
    private String eventPurge = "";
    private String traitPurgeVal = "0";
    private String traitPurge = "";
    private String availPurgeVal = "0";
    private String availPurge = "";
    private String baselineFrequencyVal = "0";
    private String baselineFrequency = "";
    private String baselineDataSetVal = "0";
    private String baselineDataSet = "";
    private String ldapUrl = "";
    private boolean ldapSsl = false;
    private String ldapLoginProperty = "";
    private String ldapSearchBase = "";
    private String ldapSearchFilter = "";
    private String ldapUsername = "";
    private String ldapPassword = "";
    private Boolean ldapEnabled = null;
    private boolean reindex = false;
    private String snmpAuthProtocol = "";
    private String snmpAuthPassphrase = "";
    private String snmpPrivacyPassphrase = "";
    private String snmpCommunity = "";
    private String snmpEngineID = "";
    private String snmpContextName = "";
    private String snmpSecurityName = "";
    private String snmpTrapOID = "";
    private String snmpEnterpriseOID = "";
    private String snmpGenericID = "";
    private String snmpSpecificID = "";
    private String snmpAgentAddress = "";
    private String snmpVersion = "";
    private String snmpPrivacyProtocol = "";

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" baseUrl=").append(this.baseUrl);
        buf.append(" agentMaxQuietTimeAllowed=").append(this.agentMaxQuietTimeAllowed);
        buf.append(" enableAgentAutoUpdate=").append(this.enableAgentAutoUpdate);
        buf.append(" enableDebugMode=").append(this.enableDebugMode);
        buf.append(" helpUserId=").append(this.helpUserId);
        buf.append(" helpPassword=").append(this.helpPassword);
        buf.append(" ldapEnabled=").append(this.ldapEnabled);
        buf.append(" ldapUrl=").append(this.ldapUrl);
        buf.append(" ldapSsl=").append(this.ldapSsl);
        buf.append(" ldapLoginProperty=").append(this.ldapLoginProperty);
        buf.append(" ldapSearchBase=").append(this.ldapSearchBase);
        buf.append(" ldapSearchFilter=").append(this.ldapSearchFilter);
        buf.append(" ldapUsername=").append(this.ldapUsername);
        buf.append(" ldapPassword=").append(this.ldapPassword);
        buf.append(" snmpAuthProtocol =").append(this.snmpAuthProtocol);
        buf.append(" snmpAuthPassphrase =").append(this.snmpAuthPassphrase);
        buf.append(" snmpPrivacyPassphrase =").append(this.snmpPrivacyPassphrase);
        buf.append(" snmpCommunity =").append(this.snmpCommunity);
        buf.append(" snmpEngineID =").append(this.snmpEngineID);
        buf.append(" snmpContextName =").append(this.snmpContextName);
        buf.append(" snmpSecurityName =").append(this.snmpSecurityName);
        buf.append(" snmpTrapOID =").append(this.snmpTrapOID);
        buf.append(" snmpEnterpriseOID =").append(this.snmpEnterpriseOID);
        buf.append(" snmpGenericID =").append(this.snmpGenericID);
        buf.append(" snmpSpecificID =").append(this.snmpSpecificID);
        buf.append(" snmpAgentAddress =").append(this.snmpAgentAddress);
        buf.append(" snmpVersion =").append(this.snmpVersion);
        buf.append(" snmpPrivacyProtocol =").append(this.snmpPrivacyProtocol);
        return buf.toString();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.agentMaxQuietTimeAllowed = "";
        this.agentMaxQuietTimeAllowedVal = null;
        this.enableAgentAutoUpdate = true;
        this.enableDebugMode = false;
        this.helpUserId = "";
        this.helpPassword = "";
        this.maintInterval = "";
        this.maintIntervalVal = null;
        this.rtPurge = "";
        this.rtPurgeVal = null;
        this.alertPurge = "";
        this.alertPurgeVal = null;
        this.eventPurge = "";
        this.eventPurgeVal = null;
        this.traitPurge = "";
        this.traitPurgeVal = null;
        this.availPurge = "";
        this.availPurgeVal = null;
        this.baselineFrequency = "";
        this.baselineFrequencyVal = null;
        this.baselineDataSet = "";
        this.baselineDataSetVal = null;
        this.ldapEnabled = null;
        this.ldapUrl = "";
        this.ldapSsl = false;
        this.ldapLoginProperty = "";
        this.ldapSearchBase = "";
        this.ldapSearchFilter = "";
        this.ldapUsername = "";
        this.ldapPassword = "";
        this.snmpAuthProtocol = "";
        this.snmpAuthPassphrase = "";
        this.snmpPrivacyPassphrase = "";
        this.snmpCommunity = "";
        this.snmpEngineID = "";
        this.snmpContextName = "";
        this.snmpSecurityName = "";
        this.snmpTrapOID = "";
        this.snmpEnterpriseOID = "";
        this.snmpGenericID = "";
        this.snmpSpecificID = "";
        this.snmpAgentAddress = "";
        this.snmpVersion = "";
        this.snmpPrivacyProtocol = "";
        super.reset(mapping, request);
    }

    public void loadConfigProperties(Properties prop) {
        this.baseUrl = prop.getProperty("CAM_BASE_URL");
        this.helpUserId = prop.getProperty("CAM_HELP_USER");
        this.helpPassword = prop.getProperty("CAM_HELP_PASSWORD");
        String agentMaxQuietTimeAllowedValStr = prop.getProperty("AGENT_MAX_QUIET_TIME_ALLOWED");
        Long agentMaxQuietTimeAllowedLong = new Long(agentMaxQuietTimeAllowedValStr);
        this.agentMaxQuietTimeAllowed = this.findTimeUnit(agentMaxQuietTimeAllowedLong.longValue());
        this.agentMaxQuietTimeAllowedVal = this.calcTimeUnit(agentMaxQuietTimeAllowedLong.longValue());
        String enableAgentAutoUpdateStr = prop.getProperty("ENABLE_AGENT_AUTO_UPDATE");
        if (enableAgentAutoUpdateStr == null) {
            enableAgentAutoUpdateStr = Boolean.FALSE.toString();
        } else if (enableAgentAutoUpdateStr.equals("0")) {
            enableAgentAutoUpdateStr = Boolean.FALSE.toString();
        } else if (enableAgentAutoUpdateStr.equals("1")) {
            enableAgentAutoUpdateStr = Boolean.TRUE.toString();
        }
        this.enableAgentAutoUpdate = Boolean.valueOf(enableAgentAutoUpdateStr);
        String enableDebugModeStr = prop.getProperty("ENABLE_DEBUG_MODE");
        if (enableDebugModeStr == null) {
            enableDebugModeStr = Boolean.FALSE.toString();
        } else if (enableDebugModeStr.equals("0")) {
            enableDebugModeStr = Boolean.FALSE.toString();
        } else if (enableDebugModeStr.equals("1")) {
            enableDebugModeStr = Boolean.TRUE.toString();
        }
        this.enableDebugMode = Boolean.valueOf(enableDebugModeStr);
        String maintIntervalValStr = prop.getProperty("CAM_DATA_MAINTENANCE");
        Long maintIntervalLong = new Long(maintIntervalValStr);
        this.maintInterval = this.findTimeUnit(maintIntervalLong.longValue());
        this.maintIntervalVal = this.calcTimeUnit(maintIntervalLong.longValue());
        String nightlyReindexStr = prop.getProperty("DATA_REINDEX_NIGHTLY");
        if (nightlyReindexStr == null) {
            nightlyReindexStr = Boolean.FALSE.toString();
        } else if (nightlyReindexStr.equals("0")) {
            nightlyReindexStr = Boolean.FALSE.toString();
        } else if (nightlyReindexStr.equals("1")) {
            nightlyReindexStr = Boolean.TRUE.toString();
        }
        this.reindex = Boolean.valueOf(nightlyReindexStr);
        String rtPurgeValStr = prop.getProperty("RT_DATA_PURGE");
        Long rtPurgeLong = new Long(rtPurgeValStr);
        this.rtPurge = this.findTimeUnit(rtPurgeLong.longValue());
        this.rtPurgeVal = this.calcTimeUnit(rtPurgeLong.longValue());
        String alertPurgeValStr = prop.getProperty("ALERT_PURGE");
        Long alertPurgeLong = new Long(alertPurgeValStr);
        this.alertPurge = this.findTimeUnit(alertPurgeLong.longValue());
        this.alertPurgeVal = this.calcTimeUnit(alertPurgeLong.longValue());
        String eventPurgeValStr = prop.getProperty("EVENT_PURGE");
        Long eventPurgeLong = new Long(eventPurgeValStr);
        this.eventPurge = this.findTimeUnit(eventPurgeLong.longValue());
        this.eventPurgeVal = this.calcTimeUnit(eventPurgeLong.longValue());
        String traitPurgeValStr = prop.getProperty("TRAIT_PURGE");
        Long traitPurgeLong = new Long(traitPurgeValStr);
        this.traitPurge = this.findTimeUnit(traitPurgeLong.longValue());
        this.traitPurgeVal = this.calcTimeUnit(traitPurgeLong.longValue());
        String availPurgeValStr = prop.getProperty("AVAILABILITY_PURGE");
        Long availPurgeLong = new Long(availPurgeValStr);
        this.availPurge = this.findTimeUnit(availPurgeLong.longValue());
        this.availPurgeVal = this.calcTimeUnit(availPurgeLong.longValue());
        String baselineFrequencyValStr = prop.getProperty("CAM_BASELINE_FREQUENCY");
        Long baselineFrequencyLong = new Long(baselineFrequencyValStr);
        this.baselineFrequency = this.findTimeUnit(baselineFrequencyLong.longValue());
        this.baselineFrequencyVal = this.calcTimeUnit(baselineFrequencyLong.longValue());
        String baselineDataSetValStr = prop.getProperty("CAM_BASELINE_DATASET");
        Long baselineDataSetLong = new Long(baselineDataSetValStr);
        this.baselineDataSet = this.findTimeUnit(baselineDataSetLong.longValue());
        this.baselineDataSetVal = this.calcTimeUnit(baselineDataSetLong.longValue());
        this.ldapUrl = prop.getProperty("CAM_LDAP_NAMING_PROVIDER_URL");
        this.ldapLoginProperty = prop.getProperty("CAM_LDAP_LOGIN_PROPERTY");
        this.ldapSearchBase = prop.getProperty("CAM_LDAP_BASE_DN");
        this.ldapSearchFilter = prop.getProperty("CAM_LDAP_FILTER");
        this.ldapUsername = prop.getProperty("CAM_LDAP_BIND_DN");
        this.ldapPassword = prop.getProperty("CAM_LDAP_BIND_PW");
        String ldapProtocol = prop.getProperty("CAM_LDAP_PROTOCOL");
        this.ldapSsl = ldapProtocol.equals("ssl");
        String jaasProvider = prop.getProperty("CAM_JAAS_PROVIDER");
        this.ldapEnabled = "LDAP".equals(jaasProvider) ? Boolean.TRUE : null;
        this.snmpAuthProtocol = prop.getProperty("SNMP_AUTH_PROTOCOL");
        this.snmpAuthPassphrase = prop.getProperty("SNMP_AUTH_PASSPHRASE");
        this.snmpPrivacyPassphrase = prop.getProperty("SNMP_PRIV_PASSPHRASE");
        this.snmpCommunity = prop.getProperty("SNMP_COMMUNITY");
        this.snmpEngineID = prop.getProperty("SNMP_ENGINE_ID");
        this.snmpContextName = prop.getProperty("SNMP_CONTEXT_NAME");
        this.snmpSecurityName = prop.getProperty("SNMP_SECURITY_NAME");
        this.snmpTrapOID = prop.getProperty("SNMP_TRAP_OID");
        this.snmpEnterpriseOID = prop.getProperty("SNMP_ENTERPRISE_OID");
        this.snmpGenericID = prop.getProperty("SNMP_GENERIC_ID");
        this.snmpSpecificID = prop.getProperty("SNMP_SPECIFIC_ID");
        this.snmpAgentAddress = prop.getProperty("SNMP_AGENT_ADDRESS");
        this.snmpVersion = prop.getProperty("SNMP_VERSION");
        this.snmpPrivacyProtocol = prop.getProperty("SNMP_PRIVACY_PROTOCOL");
    }

    private String findTimeUnit(long timeUnitInt) {
        if (timeUnitInt % 86400000L == 0L) {
            return "days";
        }
        if (timeUnitInt % 3600000L == 0L) {
            return "hours";
        }
        return "minutes";
    }

    private String calcTimeUnit(long timeUnitInt) {
        if (timeUnitInt % 86400000L == 0L) {
            return String.valueOf(timeUnitInt / 86400000L);
        }
        if (timeUnitInt % 3600000L == 0L) {
            return String.valueOf(timeUnitInt / 3600000L);
        }
        return String.valueOf(timeUnitInt / 60000L);
    }

    private long convertToMillisecond(long val, String timeLabel) {
        if (timeLabel.equalsIgnoreCase("days")) {
            return val * 86400000L;
        }
        if (timeLabel.equalsIgnoreCase("hours")) {
            return val * 3600000L;
        }
        return val * 60000L;
    }

    public Properties saveConfigProperties(Properties prop) {
        prop.setProperty("CAM_BASE_URL", this.baseUrl);
        prop.setProperty("CAM_HELP_USER", this.helpUserId);
        prop.setProperty("CAM_HELP_PASSWORD", this.helpPassword);
        prop.setProperty("DATA_REINDEX_NIGHTLY", String.valueOf(this.reindex));
        long agentMaxQuietTimeAllowedLong = this.convertToMillisecond((long)Integer.parseInt(this.agentMaxQuietTimeAllowedVal), this.agentMaxQuietTimeAllowed);
        prop.setProperty("AGENT_MAX_QUIET_TIME_ALLOWED", String.valueOf(agentMaxQuietTimeAllowedLong));
        prop.setProperty("ENABLE_AGENT_AUTO_UPDATE", String.valueOf(this.enableAgentAutoUpdate));
        prop.setProperty("ENABLE_DEBUG_MODE", String.valueOf(this.enableDebugMode));
        long maintIntervalLong = this.convertToMillisecond((long)Integer.parseInt(this.maintIntervalVal), this.maintInterval);
        prop.setProperty("CAM_DATA_MAINTENANCE", String.valueOf(maintIntervalLong));
        long rtPurgeLong = this.convertToMillisecond(Long.parseLong(this.rtPurgeVal), this.rtPurge);
        prop.setProperty("RT_DATA_PURGE", String.valueOf(rtPurgeLong));
        long alertPurgeLong = this.convertToMillisecond(Long.parseLong(this.alertPurgeVal), this.alertPurge);
        prop.setProperty("ALERT_PURGE", String.valueOf(alertPurgeLong));
        long eventPurgeLong = this.convertToMillisecond(Long.parseLong(this.eventPurgeVal), this.eventPurge);
        prop.setProperty("EVENT_PURGE", String.valueOf(eventPurgeLong));
        long traitPurgeLong = this.convertToMillisecond(Long.parseLong(this.traitPurgeVal), this.traitPurge);
        prop.setProperty("TRAIT_PURGE", String.valueOf(traitPurgeLong));
        long availPurgeLong = this.convertToMillisecond(Long.parseLong(this.availPurgeVal), this.availPurge);
        prop.setProperty("AVAILABILITY_PURGE", String.valueOf(availPurgeLong));
        long baselineFrequencyLong = this.convertToMillisecond((long)Integer.parseInt(this.baselineFrequencyVal), this.baselineFrequency);
        prop.setProperty("CAM_BASELINE_FREQUENCY", String.valueOf(baselineFrequencyLong));
        long baselineDataSetLong = this.convertToMillisecond((long)Integer.parseInt(this.baselineDataSetVal), this.baselineDataSet);
        prop.setProperty("CAM_BASELINE_DATASET", String.valueOf(baselineDataSetLong));
        prop.setProperty("CAM_LDAP_NAMING_PROVIDER_URL", this.ldapUrl);
        prop.setProperty("CAM_LDAP_LOGIN_PROPERTY", this.ldapLoginProperty);
        prop.setProperty("CAM_LDAP_BASE_DN", this.ldapSearchBase);
        prop.setProperty("CAM_LDAP_FILTER", this.ldapSearchFilter);
        prop.setProperty("CAM_LDAP_BIND_DN", this.ldapUsername);
        prop.setProperty("CAM_LDAP_BIND_PW", this.ldapPassword);
        prop.setProperty("CAM_LDAP_PROTOCOL", this.ldapSsl ? "ssl" : "");
        if (this.ldapEnabled != null) {
            prop.setProperty("CAM_JAAS_PROVIDER", "LDAP");
        } else {
            prop.setProperty("CAM_JAAS_PROVIDER", "JDBC");
        }
        prop.setProperty("SNMP_VERSION", this.snmpVersion);
        if (this.snmpVersion.length() > 0) {
            prop.setProperty("SNMP_TRAP_OID", this.snmpTrapOID);
            if ("3".equals(this.snmpVersion)) {
                prop.setProperty("SNMP_AUTH_PROTOCOL", this.snmpAuthProtocol);
                prop.setProperty("SNMP_AUTH_PASSPHRASE", this.snmpAuthPassphrase);
                prop.setProperty("SNMP_PRIV_PASSPHRASE", this.snmpPrivacyPassphrase);
                prop.setProperty("SNMP_PRIVACY_PROTOCOL", this.snmpPrivacyProtocol);
                prop.setProperty("SNMP_CONTEXT_NAME", this.snmpContextName);
                prop.setProperty("SNMP_SECURITY_NAME", this.snmpSecurityName);
            } else {
                prop.setProperty("SNMP_COMMUNITY", this.snmpCommunity);
                if ("1".equals(this.snmpVersion)) {
                    prop.setProperty("SNMP_ENGINE_ID", this.snmpEngineID);
                    prop.setProperty("SNMP_ENTERPRISE_OID", this.snmpEnterpriseOID);
                    prop.setProperty("SNMP_GENERIC_ID", this.snmpGenericID);
                    prop.setProperty("SNMP_SPECIFIC_ID", this.snmpSpecificID);
                    prop.setProperty("SNMP_AGENT_ADDRESS", this.snmpAgentAddress);
                }
            }
        }
        return prop;
    }

    public String getHelpPassword() {
        return this.helpPassword;
    }

    public String getHelpUserId() {
        return this.helpUserId;
    }

    public void setHelpPassword(String string) {
        this.helpPassword = string;
    }

    public void setHelpUserId(String string) {
        this.helpUserId = string;
    }

    public String getAgentMaxQuietTimeAllowed() {
        return this.agentMaxQuietTimeAllowed;
    }

    public void setAgentMaxQuietTimeAllowed(String string) {
        this.agentMaxQuietTimeAllowed = string;
    }

    public String getAgentMaxQuietTimeAllowedVal() {
        return this.agentMaxQuietTimeAllowedVal;
    }

    public void setAgentMaxQuietTimeAllowedVal(String string) {
        this.agentMaxQuietTimeAllowedVal = string;
    }

    public boolean getEnableAgentAutoUpdate() {
        return this.enableAgentAutoUpdate;
    }

    public void setEnableAgentAutoUpdate(boolean b) {
        this.enableAgentAutoUpdate = b;
    }

    public boolean getEnableDebugMode() {
        return this.enableDebugMode;
    }

    public void setEnableDebugMode(boolean b) {
        this.enableDebugMode = b;
    }

    public String getMaintIntervalVal() {
        return this.maintIntervalVal;
    }

    public void setMaintIntervalVal(String v) {
        this.maintIntervalVal = v;
    }

    public String getMaintInterval() {
        return this.maintInterval;
    }

    public void setMaintInterval(String s) {
        this.maintInterval = s;
    }

    public String getRtPurgeVal() {
        return this.rtPurgeVal;
    }

    public void setRtPurgeVal(String v) {
        this.rtPurgeVal = v;
    }

    public String getRtPurge() {
        return this.rtPurge;
    }

    public void setRtPurge(String s) {
        this.rtPurge = s;
    }

    public String getAlertPurgeVal() {
        return this.alertPurgeVal;
    }

    public void setAlertPurgeVal(String v) {
        this.alertPurgeVal = v;
    }

    public String getAlertPurge() {
        return this.alertPurge;
    }

    public void setAlertPurge(String s) {
        this.alertPurge = s;
    }

    public String getEventPurgeVal() {
        return this.eventPurgeVal;
    }

    public void setEventPurgeVal(String eventPurgeVal) {
        this.eventPurgeVal = eventPurgeVal;
    }

    public String getEventPurge() {
        return this.eventPurge;
    }

    public void setEventPurge(String eventPurge) {
        this.eventPurge = eventPurge;
    }

    public String getTraitPurgeVal() {
        return this.traitPurgeVal;
    }

    public void setTraitPurgeVal(String traitPurgeVal) {
        this.traitPurgeVal = traitPurgeVal;
    }

    public String getTraitPurge() {
        return this.traitPurge;
    }

    public void setTraitPurge(String traitPurge) {
        this.traitPurge = traitPurge;
    }

    public String getAvailPurgeVal() {
        return this.availPurgeVal;
    }

    public void setAvailPurgeVal(String availPurgeVal) {
        this.availPurgeVal = availPurgeVal;
    }

    public String getAvailPurge() {
        return this.availPurge;
    }

    public void setAvailPurge(String availPurge) {
        this.availPurge = availPurge;
    }

    public String getBaselineFrequencyVal() {
        return this.baselineFrequencyVal;
    }

    public void setBaselineFrequencyVal(String v) {
        this.baselineFrequencyVal = v;
    }

    public String getBaselineFrequency() {
        return this.baselineFrequency;
    }

    public void setBaselineFrequency(String s) {
        this.baselineFrequency = s;
    }

    public String getBaselineDataSetVal() {
        return this.baselineDataSetVal;
    }

    public void setBaselineDataSetVal(String v) {
        this.baselineDataSetVal = v;
    }

    public String getBaselineDataSet() {
        return this.baselineDataSet;
    }

    public void setBaselineDataSet(String s) {
        this.baselineDataSet = s;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public Boolean getLdapEnabled() {
        return this.ldapEnabled;
    }

    public void setLdapEnabled(Boolean b) {
        if (b.booleanValue()) {
            this.ldapEnabled = Boolean.TRUE;
        }
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String s) {
        this.ldapUrl = s;
    }

    public boolean getLdapSsl() {
        return this.ldapSsl;
    }

    public void setLdapSsl(boolean b) {
        this.ldapSsl = b;
    }

    public String getLdapLoginProperty() {
        return this.ldapLoginProperty;
    }

    public void setLdapLoginProperty(String s) {
        this.ldapLoginProperty = s;
    }

    public String getLdapSearchBase() {
        return this.ldapSearchBase;
    }

    public void setLdapSearchBase(String s) {
        this.ldapSearchBase = s;
    }

    public String getLdapSearchFilter() {
        return this.ldapSearchFilter;
    }

    public void setLdapSearchFilter(String s) {
        this.ldapSearchFilter = s;
    }

    public String getLdapUsername() {
        return this.ldapUsername;
    }

    public void setLdapUsername(String s) {
        this.ldapUsername = s;
    }

    public String getLdapPassword() {
        return this.ldapPassword;
    }

    public void setLdapPassword(String s) {
        this.ldapPassword = s;
    }

    public boolean getReindex() {
        return this.reindex;
    }

    public void setReindex(boolean reindex) {
        this.reindex = reindex;
    }

    public String getSnmpAgentAddress() {
        return this.snmpAgentAddress;
    }

    public void setSnmpAgentAddress(String snmpAgentAddress) {
        this.snmpAgentAddress = snmpAgentAddress;
    }

    public String getSnmpAuthPassphrase() {
        return this.snmpAuthPassphrase;
    }

    public void setSnmpAuthPassphrase(String snmpAuthPassphrase) {
        this.snmpAuthPassphrase = snmpAuthPassphrase;
    }

    public String getSnmpAuthProtocol() {
        return this.snmpAuthProtocol;
    }

    public void setSnmpAuthProtocol(String snmpAuthProtocol) {
        this.snmpAuthProtocol = snmpAuthProtocol;
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        this.snmpCommunity = snmpCommunity;
    }

    public String getSnmpContextName() {
        return this.snmpContextName;
    }

    public void setSnmpContextName(String snmpContextName) {
        this.snmpContextName = snmpContextName;
    }

    public String getSnmpEngineID() {
        return this.snmpEngineID;
    }

    public void setSnmpEngineID(String snmpEngineID) {
        this.snmpEngineID = snmpEngineID;
    }

    public String getSnmpEnterpriseOID() {
        return this.snmpEnterpriseOID;
    }

    public void setSnmpEnterpriseOID(String snmpEnterpriseOID) {
        this.snmpEnterpriseOID = snmpEnterpriseOID;
    }

    public String getSnmpGenericID() {
        return this.snmpGenericID;
    }

    public void setSnmpGenericID(String snmpGenericID) {
        this.snmpGenericID = snmpGenericID;
    }

    public String getSnmpPrivacyPassphrase() {
        return this.snmpPrivacyPassphrase;
    }

    public void setSnmpPrivacyPassphrase(String snmpPrivacyPassphrase) {
        this.snmpPrivacyPassphrase = snmpPrivacyPassphrase;
    }

    public String getSnmpPrivacyProtocol() {
        return this.snmpPrivacyProtocol;
    }

    public void setSnmpPrivacyProtocol(String snmpPrivacyProtocol) {
        this.snmpPrivacyProtocol = snmpPrivacyProtocol;
    }

    public String getSnmpSecurityName() {
        return this.snmpSecurityName;
    }

    public void setSnmpSecurityName(String snmpSecurityName) {
        this.snmpSecurityName = snmpSecurityName;
    }

    public String getSnmpSpecificID() {
        return this.snmpSpecificID;
    }

    public void setSnmpSpecificID(String snmpSpecificID) {
        this.snmpSpecificID = snmpSpecificID;
    }

    public String getSnmpTrapOID() {
        return this.snmpTrapOID;
    }

    public void setSnmpTrapOID(String snmpTrapOID) {
        this.snmpTrapOID = snmpTrapOID;
    }

    public String getSnmpVersion() {
        return this.snmpVersion;
    }

    public void setSnmpVersion(String snmpVersion) {
        this.snmpVersion = snmpVersion;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionMessage errorMessage;
        ActionMessage errorMessage2;
        ActionMessage errorMessage3;
        ActionErrors errors = super.validate(mapping, request);
        if (errors == null) {
            errors = new ActionErrors();
        }
        if (!this.empty(this.snmpVersion) && "3".equals(this.snmpVersion) && !this.empty(this.snmpAuthProtocol) && this.empty(this.snmpAuthPassphrase)) {
            errorMessage3 = new ActionMessage("admin.settings.SNMPAuthPassphrase");
            errors.add("snmpAuthPassphrase", errorMessage3);
        }
        if (!this.empty(this.snmpVersion) && "3".equals(this.snmpVersion) && !this.empty(this.snmpPrivacyProtocol) && this.empty(this.snmpPrivacyPassphrase)) {
            errorMessage3 = new ActionMessage("admin.settings.SNMPPrivPassphrase");
            errors.add("snmpPrivacyPassphrase", errorMessage3);
        }
        if (!this.empty(this.baselineDataSetVal)) {
            try {
                long freq = Long.parseLong(this.baselineDataSetVal);
                if (freq > 14L) {
                    errorMessage2 = new ActionMessage("admin.settings.BadBaselineDataSetVal");
                    errors.add("baselineDataSetVal", errorMessage2);
                }
            }
            catch (Exception e) {
                errorMessage = new ActionMessage("admin.settings.BadBaselineDataSetVal");
                errors.add("baselineDataSetVal", errorMessage);
            }
        }
        if (!this.empty(this.agentMaxQuietTimeAllowedVal)) {
            try {
                long val = Long.parseLong(this.agentMaxQuietTimeAllowedVal);
                if (val < 2L) {
                    errorMessage2 = new ActionMessage("admin.settings.BadAgentMaxQuietTimeAllowedVal");
                    errors.add("agentMaxQuietTimeAllowedVal", errorMessage2);
                }
            }
            catch (Exception e) {
                errorMessage = new ActionMessage("admin.settings.BadAgentMaxQuietTimeAllowedVal");
                errors.add("agentMaxQuietTimeAllowedVal", errorMessage);
            }
        }
        this.checkForBadNumber(errors, this.maintIntervalVal, "maintIntervalVal");
        this.checkForBadNumber(errors, this.rtPurgeVal, "rtPurgeVal");
        this.checkForBadNumber(errors, this.alertPurgeVal, "alertPurgeVal");
        this.checkForBadNumber(errors, this.eventPurgeVal, "eventPurgeVal");
        this.checkForBadNumber(errors, this.traitPurgeVal, "traitPurgeVal");
        this.checkForBadNumber(errors, this.availPurgeVal, "availPurgeVal");
        this.checkForBadNumber(errors, this.baselineFrequencyVal, "baselineFrequencyVal");
        if (errors.isEmpty()) {
            return null;
        }
        return errors;
    }

    private void checkForBadNumber(ActionErrors errors, String val, String valVariableName) {
        if (!this.empty(val)) {
            try {
                Long.parseLong(val);
            }
            catch (Exception e) {
                ActionMessage errorMessage = new ActionMessage("admin.settings.BadNumber");
                errors.add(valVariableName, errorMessage);
            }
        }
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }
}

