/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.alert.ListGroupAlertHistoryUIBean;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListGroupAlertHistoryUIBean
extends PagedDataTableUIBean {
    private static final Log log = LogFactory.getLog(ListGroupAlertHistoryUIBean.class);
    public static final String MANAGED_BEAN_NAME = "ListGroupAlertHistoryUIBean";
    private String dateFilter;
    private String dateErrors;
    private String alertDefinitionFilter;
    private String alertPriorityFilter;
    private SelectItem[] alertPrioritySelectItems;
    private AlertManagerLocal alertManager = LookupUtil.getAlertManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public String getDateFilter() {
        if (this.dateFilter == null) {
            this.dateFilter = FacesContextUtility.getOptionalRequestParameter((String)"alertHistoryForm:dateFilter");
        }
        return this.dateFilter;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public String getDateErrors() {
        return this.dateErrors;
    }

    public void setDateErrors(String dateErrors) {
        this.dateErrors = dateErrors;
    }

    public String getAlertDefinitionFilter() {
        if (this.alertDefinitionFilter == null) {
            this.alertDefinitionFilter = SelectItemUtils.getSelectItemFilter((String)"alertHistoryForm:alertDefinitionFilter");
        }
        return SelectItemUtils.cleanse((String)this.alertDefinitionFilter);
    }

    public void setAlertDefinitionFilter(String alertDefinitionFilter) {
        this.alertDefinitionFilter = alertDefinitionFilter;
    }

    public String getAlertPriorityFilter() {
        if (this.alertPriorityFilter == null) {
            this.alertPriorityFilter = SelectItemUtils.getSelectItemFilter((String)"alertHistoryForm:alertPriorityFilter");
        }
        return SelectItemUtils.cleanse((String)this.alertPriorityFilter);
    }

    public void setAlertPriorityFilter(String alertPriorityFilter) {
        this.alertPriorityFilter = alertPriorityFilter;
    }

    public SelectItem[] getAlertPrioritySelectItems() {
        if (this.alertPrioritySelectItems == null) {
            this.alertPrioritySelectItems = SelectItemUtils.convertFromEnum(AlertPriority.class, (boolean)true);
        }
        return this.alertPrioritySelectItems;
    }

    public void setAlertPrioritySelectItems(SelectItem[] alertPrioritySelectItems) {
        this.alertPrioritySelectItems = alertPrioritySelectItems;
    }

    public String deleteSelectedAlerts() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceGroup resourceGroup = EnterpriseFacesContextUtility.getResourceGroup();
        String[] selectedAlerts = this.getSelectedAlerts();
        Integer[] alertDefinitionIds = StringUtility.getIntegerArray((String[])selectedAlerts);
        try {
            this.alertManager.deleteAlertsForResourceGroup(subject, resourceGroup.getId(), alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + alertDefinitionIds.length + " alerts."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected alerts.", (Throwable)e);
        }
        return "success";
    }

    public String purgeAllAlerts() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceGroup resourceGroup = EnterpriseFacesContextUtility.getResourceGroup();
        try {
            int numDeleted = 0;
            for (Integer resourceId : this.resourceManager.findImplicitResourceIdsByResourceGroup(resourceGroup.getId())) {
                numDeleted += this.alertManager.deleteAlerts(subject, resourceId.intValue());
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + numDeleted + " alerts on this group"));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to delete alerts for group[ " + resourceGroup.getId() + " ]"), (Throwable)e);
            log.error((Object)("failed to delete alerts for group[ " + resourceGroup.getId() + " ]"), (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListGroupAlertDefinitionsDataModel(this, PageControlView.GroupAlertHistoryList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private Integer getAlertDefinitionId() {
        String alertDefinitionString = this.getAlertDefinitionFilter();
        if (alertDefinitionString != null) {
            return Integer.parseInt(alertDefinitionString);
        }
        return null;
    }

    private AlertPriority getAlertPriority() {
        String alertPriorityName = this.getAlertPriorityFilter();
        if (alertPriorityName != null) {
            return Enum.valueOf(AlertPriority.class, alertPriorityName);
        }
        return null;
    }

    private String[] getSelectedAlerts() {
        return FacesContextUtility.getRequest().getParameterValues("selectedAlerts");
    }

    static /* synthetic */ Integer access$000(ListGroupAlertHistoryUIBean x0) {
        return x0.getAlertDefinitionId();
    }

    static /* synthetic */ AlertPriority access$100(ListGroupAlertHistoryUIBean x0) {
        return x0.getAlertPriority();
    }

    static /* synthetic */ AlertManagerLocal access$200(ListGroupAlertHistoryUIBean x0) {
        return x0.alertManager;
    }
}

