/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.upload;

import java.io.File;
import java.io.FileNotFoundException;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;

public class FileUploadUIBean {
    private final Log log = LogFactory.getLog(FileUploadUIBean.class);
    private UploadItem fileItem;

    public UploadItem getFileItem() {
        return this.fileItem;
    }

    public void setFileItem(UploadItem fileItem) {
        this.fileItem = fileItem;
    }

    public boolean isFileUploaded() {
        return this.getFileItem() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        try {
            block4: {
                try {
                    if (!this.isFileUploaded()) break block4;
                    this.getFileItem().getFile().delete();
                }
                catch (Exception exception) {
                    Object var3_2 = null;
                    this.setFileItem(null);
                    return;
                }
            }
            Object var3_1 = null;
            this.setFileItem(null);
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setFileItem(null);
            throw throwable;
        }
    }

    public void fileUploadListener(UploadEvent event) {
        try {
            this.clear();
            this.setFileItem(event.getUploadItem());
            File uploadedFile = this.getFileItem().getFile();
            if (uploadedFile == null || !uploadedFile.exists()) {
                throw new FileNotFoundException("The uploaded file [" + uploadedFile + "] does not exist!");
            }
            String uploadedFilename = this.getFileItem().getFileName();
            long uploadedFileSize = uploadedFile.length();
            this.log.info((Object)("A file named [" + uploadedFilename + "] with a size of [" + uploadedFileSize + "] has been uploaded to [" + uploadedFile + "]"));
            this.onSuccess();
        }
        catch (Throwable t) {
            this.onFailure(t);
        }
    }

    public String toString() {
        String fileInfo = "no file has been uploaded yet";
        if (this.fileItem != null) {
            fileInfo = "fileName=" + this.fileItem.getFileName() + ", size=" + this.fileItem.getFileSize() + ", file=" + this.fileItem.getFile();
        }
        return this.getClass().getSimpleName() + ": " + fileInfo;
    }

    protected void onSuccess() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Content has been received");
    }

    protected void onFailure(Throwable t) {
        String msg = "Failed to process uploaded file. Cause: " + ThrowableUtil.getAllMessages((Throwable)t);
        this.log.error((Object)msg);
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)msg, (Throwable)t);
    }
}

