/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ChannelSubscriptionsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ChannelSubscriptionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ChannelSubscriptionsUIBean";

    public String deleteSelectedChannelSubscriptions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedChannelSubscriptions();
        int channelId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] resourceIds = this.getIntegerArray(selected);
        if (resourceIds != null && resourceIds.length > 0) {
            try {
                ChannelManagerLocal manager = LookupUtil.getChannelManagerLocal();
                for (int resourceId : resourceIds) {
                    manager.unsubscribeResourceFromChannels(subject, resourceId, new int[]{channelId});
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Unsubscribed [" + resourceIds.length + "] resources from channel"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to unsubscribe one or more resources from channel", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ChannelSubscriptionsDataModel(this, PageControlView.ChannelSubscriptionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedChannelSubscriptions() {
        return FacesContextUtility.getRequest().getParameterValues("selectedChannelSubscriptions");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

