/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ChannelUnsubscriptionsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ChannelUnsubscriptionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ChannelUnsubscriptionsUIBean";
    private String searchString = null;
    private String searchCategory = null;

    public String getSearchCategory() {
        if (this.searchCategory == null) {
            this.searchCategory = ResourceCategory.PLATFORM.name();
        }
        return this.searchCategory;
    }

    public void setSearchCategory(String category) {
        this.searchCategory = category;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String associateSelectedContentSourcesWithChannel() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedChannelUnsubscriptions();
        int channelId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        int[] resourceIds = this.getIntegerArray(selected);
        if (resourceIds != null && resourceIds.length > 0) {
            try {
                ChannelManagerLocal manager = LookupUtil.getChannelManagerLocal();
                for (int resourceId : resourceIds) {
                    manager.subscribeResourceToChannels(subject, resourceId, new int[]{channelId});
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Subscribed [" + resourceIds.length + "] resources with channel"));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to subscribe one or more resources with channel", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ChannelUnsubscriptionsDataModel(this, PageControlView.ChannelUnsubscriptionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedChannelUnsubscriptions() {
        return FacesContextUtility.getRequest().getParameterValues("selectedChannelUnsubscriptions");
    }

    private int[] getIntegerArray(String[] input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

