/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Channel;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.composite.ChannelComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.content.UploadNewPackageUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ChannelManagerLocal;
import org.rhq.enterprise.server.content.ContentException;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.model.UploadItem;

public class CreateNewPackageUIBean {
    private static final String CHANNEL_OPTION_SUBSCRIBED = "subscribed";
    private static final String CHANNEL_OPTION_UNSUBSCRIBED = "unsubscribed";
    private static final String CHANNEL_OPTION_NEW = "new";
    private String packageName;
    private String version;
    private int selectedArchitectureId;
    private int selectedPackageTypeId;
    private String subscribedChannelId;
    private String unsubscribedChannelId;
    private String newChannelName;
    private ResourceType resourceType;
    private InstalledPackage backingPackage;
    private final Log log = LogFactory.getLog(this.getClass());

    public String cancel() {
        UploadNewPackageUIBean uploadUIBean = (UploadNewPackageUIBean)FacesContextUtility.getManagedBean(UploadNewPackageUIBean.class);
        if (uploadUIBean != null) {
            uploadUIBean.clear();
        }
        return "cancel";
    }

    public String createPackage() {
        String response;
        HttpServletRequest request = FacesContextUtility.getRequest();
        if (request.getParameter("newPackage") != null) {
            response = this.createNewPackage(this.packageName, this.version, this.selectedArchitectureId, this.selectedPackageTypeId);
        } else {
            String packageName = this.getBackingPackageName();
            String version = Long.toString(System.currentTimeMillis());
            int architectureId = this.getBackingPackageArchitectureId();
            int packageTypeId = this.getBackingPackageTypeId();
            response = this.createNewPackage(packageName, version, architectureId, packageTypeId);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNewPackage(String packageName, String version, int architectureId, int packageTypeId) {
        PackageVersion packageVersion;
        FileInputStream packageStream;
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        HttpServletRequest request = FacesContextUtility.getRequest();
        UploadNewPackageUIBean uploadUIBean = (UploadNewPackageUIBean)FacesContextUtility.getManagedBean(UploadNewPackageUIBean.class);
        String channelOption = request.getParameter("channelOption");
        UploadItem fileItem = uploadUIBean.getFileItem();
        if (packageName == null || packageName.trim().equals("")) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Package name must be specified");
            return null;
        }
        if (version == null || version.trim().equals("")) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Package version must be specified");
            return null;
        }
        if (channelOption == null) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"A channel deployment option must be specified");
            return null;
        }
        if (channelOption.equals(CHANNEL_OPTION_NEW) && (this.newChannelName == null || this.newChannelName.trim().equals(""))) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"When creating a new channel, the name of the channel to be created must be specified");
            return null;
        }
        if (fileItem == null || fileItem.getFile() == null) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"A package file must be uploaded");
            return null;
        }
        String channelId = null;
        try {
            channelId = this.determineChannel(channelOption, subject, resource.getId());
        }
        catch (ContentException ce) {
            String errorMessages = ThrowableUtil.getAllMessages((Throwable)ce);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to determine channel. Cause: " + errorMessages));
            return "failure";
        }
        try {
            try {
                this.log.debug((Object)("Streaming new package bits from uploaded file: " + fileItem.getFile()));
                packageStream = new FileInputStream(fileItem.getFile());
            }
            catch (IOException e) {
                String errorMessages = ThrowableUtil.getAllMessages((Throwable)e);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to retrieve the input stream. Cause: " + errorMessages));
                String string = "failure";
                Object var19_25 = null;
                uploadUIBean.clear();
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var19_29 = null;
            uploadUIBean.clear();
            throw throwable;
        }
        try {
            ContentManagerLocal contentManager = LookupUtil.getContentManager();
            packageVersion = contentManager.createPackageVersion(packageName, packageTypeId, version, architectureId, (InputStream)packageStream);
        }
        catch (Exception e) {
            String errorMessages = ThrowableUtil.getAllMessages((Throwable)e);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to create package [" + packageName + "] in channel. Cause: " + errorMessages));
            String string = "failure";
            Object var19_26 = null;
            uploadUIBean.clear();
            return string;
        }
        int[] packageVersionList = new int[]{packageVersion.getId()};
        try {
            int iChannelId = Integer.parseInt(channelId);
            ChannelManagerLocal channelManager = LookupUtil.getChannelManagerLocal();
            channelManager.addPackageVersionsToChannel(subject, iChannelId, packageVersionList);
        }
        catch (Exception e) {
            String errorMessages = ThrowableUtil.getAllMessages((Throwable)e);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to associate package [" + packageName + "] with channel ID [" + channelId + "]. Cause: " + errorMessages));
            String string = "failure";
            Object var19_27 = null;
            uploadUIBean.clear();
            return string;
        }
        HttpSession session = request.getSession();
        session.setAttribute("selectedPackages", (Object)packageVersionList);
        Object var19_28 = null;
        uploadUIBean.clear();
        return "success";
    }

    public String deployExisting() {
        String[] selectedPackages = FacesContextUtility.getRequest().getParameterValues("selectedPackages");
        if (selectedPackages == null || selectedPackages.length == 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"At least one package must be selected");
            return "failure";
        }
        int[] selectedPackageIds = new int[selectedPackages.length];
        int counter = 0;
        for (String sPackageId : selectedPackages) {
            int iPackageId = Integer.parseInt(sPackageId);
            selectedPackageIds[counter++] = iPackageId;
        }
        HttpServletRequest request = FacesContextUtility.getRequest();
        HttpSession session = request.getSession();
        session.setAttribute("selectedPackages", (Object)selectedPackageIds);
        return "success";
    }

    public SelectItem[] getArchitectures() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        List architectures = contentManager.findArchitectures(subject);
        SelectItem[] items = new SelectItem[architectures.size()];
        int itemCounter = 0;
        for (Architecture arch : architectures) {
            SelectItem item = new SelectItem((Object)arch.getId(), arch.getName());
            items[itemCounter++] = item;
        }
        return items;
    }

    public SelectItem[] getPackageTypes() {
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
        List packageTypes = contentUIManager.getPackageTypes(resource.getResourceType().getId());
        SelectItem[] items = new SelectItem[packageTypes.size()];
        int itemCounter = 0;
        for (PackageType packageType : packageTypes) {
            SelectItem item = new SelectItem((Object)packageType.getId(), packageType.getDisplayName());
            items[itemCounter++] = item;
        }
        return items;
    }

    public SelectItem[] getSubscribedChannels() {
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ChannelManagerLocal channelManager = LookupUtil.getChannelManagerLocal();
        List channels = channelManager.findResourceSubscriptions(resource.getId());
        SelectItem[] items = new SelectItem[channels.size()];
        int itemCounter = 0;
        for (ChannelComposite channelComposite : channels) {
            Channel channel = channelComposite.getChannel();
            SelectItem item = new SelectItem((Object)channel.getId(), channel.getName());
            items[itemCounter++] = item;
        }
        return items;
    }

    public SelectItem[] getUnsubscribedChannels() {
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ChannelManagerLocal channelManager = LookupUtil.getChannelManagerLocal();
        List channels = channelManager.findAvailableResourceSubscriptions(resource.getId());
        SelectItem[] items = new SelectItem[channels.size()];
        int itemCounter = 0;
        for (ChannelComposite channelComposite : channels) {
            Channel channel = channelComposite.getChannel();
            SelectItem item = new SelectItem((Object)channel.getId(), channel.getName());
            items[itemCounter++] = item;
        }
        return items;
    }

    public boolean getNeedRequestPackageDetails() {
        boolean isPackageBacked = this.isResourcePackageBacked();
        boolean backingPackageExists = this.lookupBackingPackage() != null;
        return !isPackageBacked || !backingPackageExists;
    }

    public boolean isResourcePackageBacked() {
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ResourceType resourceType = resource.getResourceType();
        return resourceType.getCreationDataType() == ResourceCreationDataType.CONTENT;
    }

    public InstalledPackage lookupBackingPackage() {
        if (this.backingPackage == null) {
            Resource resource = EnterpriseFacesContextUtility.getResource();
            ContentManagerLocal contentManager = LookupUtil.getContentManager();
            this.backingPackage = contentManager.getBackingPackageForResource(EnterpriseFacesContextUtility.getSubject(), resource.getId());
        }
        return this.backingPackage;
    }

    public String getBackingPackageName() {
        InstalledPackage ip = this.lookupBackingPackage();
        PackageVersion pv = ip.getPackageVersion();
        Package p = pv.getGeneralPackage();
        return p.getName();
    }

    public int getBackingPackageArchitectureId() {
        InstalledPackage ip = this.lookupBackingPackage();
        PackageVersion pv = ip.getPackageVersion();
        return pv.getArchitecture().getId();
    }

    public int getBackingPackageTypeId() {
        InstalledPackage ip = this.lookupBackingPackage();
        PackageVersion pv = ip.getPackageVersion();
        Package p = pv.getGeneralPackage();
        return p.getPackageType().getId();
    }

    public String getNextBackingPackageVersion() {
        return Long.toString(System.currentTimeMillis());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getSelectedArchitectureId() {
        return this.selectedArchitectureId;
    }

    public void setSelectedArchitectureId(int selectedArchitectureId) {
        this.selectedArchitectureId = selectedArchitectureId;
    }

    public int getSelectedPackageTypeId() {
        return this.selectedPackageTypeId;
    }

    public void setSelectedPackageTypeId(int selectedPackageTypeId) {
        this.selectedPackageTypeId = selectedPackageTypeId;
    }

    public String getSubscribedChannelId() {
        return this.subscribedChannelId;
    }

    public void setSubscribedChannelId(String subscribedChannelId) {
        this.subscribedChannelId = subscribedChannelId;
    }

    public String getUnsubscribedChannelId() {
        return this.unsubscribedChannelId;
    }

    public void setUnsubscribedChannelId(String unsubscribedChannelId) {
        this.unsubscribedChannelId = unsubscribedChannelId;
    }

    public String getNewChannelName() {
        return this.newChannelName;
    }

    public void setNewChannelName(String newChannelName) {
        this.newChannelName = newChannelName;
    }

    private String determineChannel(String channelOption, Subject subject, int resourceId) throws ContentException {
        String channelId = null;
        if (channelOption.equals(CHANNEL_OPTION_SUBSCRIBED)) {
            channelId = this.subscribedChannelId;
        } else if (channelOption.equals(CHANNEL_OPTION_UNSUBSCRIBED)) {
            channelId = this.unsubscribedChannelId;
            int iChannelId = Integer.parseInt(channelId);
            ChannelManagerLocal channelManager = LookupUtil.getChannelManagerLocal();
            channelManager.subscribeResourceToChannels(subject, resourceId, new int[]{iChannelId});
            this.subscribedChannelId = channelId;
        } else if (channelOption.equals(CHANNEL_OPTION_NEW)) {
            ChannelManagerLocal channelManager = LookupUtil.getChannelManagerLocal();
            Channel newChannel = new Channel(this.newChannelName);
            newChannel = channelManager.createChannel(subject, newChannel);
            channelId = Integer.toString(newChannel.getId());
            channelManager.subscribeResourceToChannels(subject, resourceId, new int[]{newChannel.getId()});
            this.subscribedChannelId = channelId;
        }
        return channelId;
    }
}

