/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.definition.group;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.definition.group.ListGroupDefinitionsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListGroupDefinitionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListGroupDefinitionsUIBean";
    private static final String OUTCOME_SUCCESS = "success";
    private static final String OUTCOME_FAILURE = "failure";
    private GroupDefinitionManagerLocal groupDefinitionManager = LookupUtil.getGroupDefinitionManager();

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListGroupDefinitionsDataModel(this, PageControlView.GroupDefinitionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public String createNewGroupDefinition() {
        return "createNew";
    }

    public String deleteSelectedGroupDefinitions() {
        String[] selectedGroupDefinitions = this.getSelectedGroupDefinitions();
        Integer[] groupDefinitionIds = this.getIntegerArray(selectedGroupDefinitions);
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        try {
            for (Integer groupDefinitionId : groupDefinitionIds) {
                this.groupDefinitionManager.removeGroupDefinition(subject, groupDefinitionId);
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Deleted selected group definitions.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete group definitions.", (Throwable)e);
            return OUTCOME_FAILURE;
        }
        return OUTCOME_SUCCESS;
    }

    private String[] getSelectedGroupDefinitions() {
        return FacesContextUtility.getRequest().getParameterValues("selectedGroupDefinitions");
    }

    private Integer[] getIntegerArray(String[] input) {
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }
}

