/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;

public class AvailabilityReportChart
extends Chart {
    private static int CIRCLE_SIZE = 11;
    private static BufferedImage GOOD_CIRCLE;
    private static BufferedImage DANGER_CIRCLE;
    private static BufferedImage UNKNOWN_CIRCLE;
    private static final int TEXT_HEIGHT = 11;
    private static final Font TEXT_FONT;
    private static final FontMetrics TEXT_METRICS;
    private static final Color COLOR_TRANSPARENT;
    private static final String LARGEST_NUMBER = "999";
    private static final int TEXT_BUFFER = 2;
    private static final int SET_BUFFER = 5;
    private static final int CIRCLE_WITH_BUFFER_WIDTH;
    private static final int STANDARD_SET_WIDTH;
    private static final int IMAGE_WIDTH;

    public AvailabilityReportChart() {
        super(IMAGE_WIDTH, GOOD_CIRCLE.getHeight());
        this.setBorder(0);
        this.indexColors = true;
    }

    protected void init() {
        this.showLeftLabels = false;
        this.showBottomLabels = false;
        this.showLeftLegend = false;
        this.showTopLegend = false;
    }

    protected Rectangle draw(ChartGraphics g) {
        String text;
        double val;
        g.graphics.setFont(TEXT_FONT);
        boolean x = false;
        int yCircle = 0;
        int y2Circle = CIRCLE_SIZE - 1;
        g.graphics.setPaint(COLOR_TRANSPARENT);
        g.graphics.fillRect(0, 0, this.width, this.height);
        DataPointCollection datapts = this.getDataPoints();
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(0);
        g.graphics.setColor(this.textColor);
        if (datapts.size() >= 1 && (val = datapts.get(0).getValue()) > 0.0) {
            text = fmt.format(val);
            g.graphics.drawImage(GOOD_CIRCLE, 0, yCircle, COLOR_TRANSPARENT, null);
            g.graphics.drawString(text, CIRCLE_WITH_BUFFER_WIDTH, y2Circle);
        }
        if (datapts.size() >= 2 && (val = datapts.get(1).getValue()) > 0.0) {
            text = fmt.format(val);
            g.graphics.drawImage(DANGER_CIRCLE, STANDARD_SET_WIDTH, yCircle, COLOR_TRANSPARENT, null);
            g.graphics.drawString(text, STANDARD_SET_WIDTH + CIRCLE_WITH_BUFFER_WIDTH, y2Circle);
        }
        if (datapts.size() >= 3 && (val = datapts.get(2).getValue()) > 0.0) {
            text = fmt.format(val);
            g.graphics.drawImage(UNKNOWN_CIRCLE, STANDARD_SET_WIDTH * 2, yCircle, COLOR_TRANSPARENT, null);
            g.graphics.drawString(text, STANDARD_SET_WIDTH * 2 + CIRCLE_WITH_BUFFER_WIDTH, y2Circle);
        }
        return new Rectangle(0, 0, this.height, this.width);
    }

    protected int getYLabelWidth(Graphics2D g) {
        return 0;
    }

    protected Rectangle getInteriorRectangle(ChartGraphics g) {
        return new Rectangle(0, 0, this.width, this.height);
    }

    protected String[] getXLabels() {
        return null;
    }

    static {
        TEXT_FONT = new Font("Helvetica", 0, 11);
        COLOR_TRANSPARENT = new Color(0, 0, 255);
        BufferedImage img = new BufferedImage(1, 1, 12);
        Graphics g = ((Image)img).getGraphics();
        TEXT_METRICS = g.getFontMetrics(TEXT_FONT);
        g.dispose();
        try {
            ClassLoader ldr = AvailabilityReportChart.class.getClassLoader();
            InputStream i = ldr.getResourceAsStream("images/icon_available_green.gif");
            GOOD_CIRCLE = ImageIO.read(i);
            i.close();
            i = ldr.getResourceAsStream("images/icon_available_red.gif");
            DANGER_CIRCLE = ImageIO.read(i);
            i.close();
            i = ldr.getResourceAsStream("images/icon_available_error.gif");
            UNKNOWN_CIRCLE = ImageIO.read(i);
            i.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        CIRCLE_WITH_BUFFER_WIDTH = GOOD_CIRCLE.getWidth() + 2;
        STANDARD_SET_WIDTH = CIRCLE_WITH_BUFFER_WIDTH + TEXT_METRICS.stringWidth(LARGEST_NUMBER) + 5;
        IMAGE_WIDTH = STANDARD_SET_WIDTH * 3 - 5;
    }
}

