/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.rhq.enterprise.gui.image.chart.Chart;

public class ChartGraphics {
    private static final int DRAW_CENTERED = 1;
    protected static final int EVENT_HEIGHT = 11;
    protected static final int EVENT_WIDTH = 11;
    protected static final int HALF_EVENT_HEIGHT = 5;
    protected static final int HALF_EVENT_WIDTH = 5;
    private static final Font EVENT_FONT = new Font("Helvetica", 1, 9);
    private Chart m_chart;
    public Graphics2D graphics;

    public ChartGraphics(Chart chart, Graphics2D graph) {
        this.m_chart = chart;
        this.graphics = graph;
    }

    public void dispose() {
        this.graphics.dispose();
    }

    public void drawEvent(int eventId, int x, int y) {
        String evt = Integer.toString(eventId);
        this.graphics.fillOval(x - 5, y - 5, 11, 11);
        Font fontOrig = this.graphics.getFont();
        Color clrOrig = this.graphics.getColor();
        this.graphics.setColor(Color.WHITE);
        this.graphics.setFont(EVENT_FONT);
        this.graphics.drawString(evt, x - this.m_chart.m_metricsLabel.stringWidth(evt) / 2 + 1, y + this.m_chart.m_metricsLabel.getAscent() / 2 - 1);
        this.graphics.setColor(clrOrig);
        this.graphics.setFont(fontOrig);
    }

    public void drawXLegendString(String text) {
        int textWidth;
        String text2;
        String text1;
        this.graphics.setColor(this.m_chart.legendTextColor);
        Rectangle rect = this.m_chart.getInteriorRectangle(this);
        int text1Width = 0;
        int paren = text.indexOf(40);
        if (paren != -1) {
            text1 = text.substring(0, paren);
            text2 = text.substring(paren);
            text1Width = this.m_chart.m_metricsLegend.stringWidth(text1);
            textWidth = text1Width + this.m_chart.m_metricsLabel.stringWidth(text2);
        } else {
            text1 = text;
            text2 = null;
            textWidth = this.m_chart.m_metricsLegend.stringWidth(text1);
        }
        int x = this.m_chart.width / 2 - textWidth / 2;
        int x2 = x + text1Width;
        if (this.m_chart.showTopLegend) {
            this.graphics.setFont(this.m_chart.legendFont);
            this.graphics.drawString(text1, x, this.m_chart.yTopLegend);
            if (text2 != null) {
                this.graphics.setFont(this.m_chart.font);
                this.graphics.drawString(text2, x2, this.m_chart.yTopLegend);
            }
        }
        if (this.m_chart.showBottomLegend) {
            this.graphics.setFont(this.m_chart.legendFont);
            this.graphics.drawString(text1, x, this.m_chart.yBottomLegend);
            if (text2 != null) {
                this.graphics.setFont(this.m_chart.font);
                this.graphics.drawString(text2, x2, this.m_chart.yBottomLegend);
            }
        }
    }

    public void drawYLegendString(String text) {
        char[] achVal = text.toCharArray();
        this.graphics.setColor(this.m_chart.legendTextColor);
        this.graphics.setFont(this.m_chart.legendFont);
        int i = 0;
        int y = this.m_chart.height / 2 - this.m_chart.m_metricsLegend.getAscent() * text.length() / 2;
        while (i < achVal.length) {
            if (this.m_chart.showLeftLegend) {
                this.graphics.drawChars(achVal, i, 1, this.m_chart.xVertLegend, y);
            }
            ++i;
            y += this.m_chart.m_metricsLegend.getAscent();
        }
    }

    public void drawXLines(int[] lines, String[] labels, boolean fullLines) {
        this.graphics.setFont(this.m_chart.font);
        FontMetrics metrics = this.graphics.getFontMetrics(this.m_chart.font);
        Rectangle rect = this.m_chart.getInteriorRectangle(this);
        int x2 = rect.x + (fullLines ? rect.width : 0);
        int y2 = rect.y + rect.height;
        int xBeginLine = rect.x;
        if (this.m_chart.showLeftLabels) {
            xBeginLine -= this.m_chart.lineWidth + this.m_chart.tickMarkHeight;
        }
        for (int i = 0; i < lines.length; ++i) {
            int y = rect.y + y2 - lines[i];
            int xEndLine = x2;
            if (this.m_chart.showRightLabels) {
                xEndLine += this.m_chart.lineWidth + this.m_chart.tickMarkHeight;
            }
            this.graphics.setColor(this.m_chart.xLineColor);
            this.graphics.drawLine(xBeginLine, y, xEndLine, y);
            this.graphics.setColor(this.m_chart.textColor);
            if (this.m_chart.showLeftLabels) {
                this.graphics.drawString(labels[i], this.m_chart.x2VertLabels - metrics.stringWidth(labels[i]), y + metrics.getAscent() / 2 - 1);
            }
            if (!this.m_chart.showRightLabels) continue;
            this.graphics.drawString(labels[i], this.m_chart.xRLabel, y + metrics.getAscent() / 2 - 1);
        }
    }

    public void drawYLines(int[] lines, String[] labels, boolean fullLines, int skip) {
        if (!this.m_chart.showBottomLabels && !this.m_chart.showTopLabels) {
            return;
        }
        this.graphics.setFont(this.m_chart.font);
        Rectangle rect = this.m_chart.getInteriorRectangle(this);
        int yBegin = rect.y + this.m_chart.lineWidth;
        int yEnd = yBegin + rect.height;
        int y = fullLines ? yBegin : yEnd;
        for (int i = 0; i < lines.length; ++i) {
            int y1 = !this.m_chart.showTopLabels ? yBegin : (!this.m_chart.showFullLabels && i % skip != 0 ? yBegin - this.m_chart.lineWidth * 2 - this.m_chart.tickMarkHeight / 2 : yBegin - this.m_chart.lineWidth * 2 - this.m_chart.tickMarkHeight);
            int y2 = !this.m_chart.showBottomLabels ? yEnd : (!this.m_chart.showFullLabels && i % skip != 0 ? yEnd + this.m_chart.tickMarkHeight / 2 : yEnd + this.m_chart.tickMarkHeight);
            this.graphics.setColor(this.m_chart.xLineColor);
            if (this.m_chart.showTopLabels) {
                this.graphics.drawLine(lines[i], y1, lines[i], yEnd);
            } else if (this.m_chart.showBottomLabels) {
                this.graphics.drawLine(lines[i], y, lines[i], y2);
            } else {
                this.graphics.drawLine(lines[i], y1, lines[i], y2 - this.m_chart.lineWidth);
            }
            if (!this.m_chart.showFullLabels && i % skip != 0 && i + 1 != labels.length) continue;
            this.graphics.setColor(this.m_chart.textColor);
            if (this.m_chart.showTopLabels && labels[i] != null) {
                this.drawString(labels[i], lines[i], y1 - this.m_chart.textWhitespace, 1);
            }
            if (!this.m_chart.showBottomLabels || labels[i] == null) continue;
            this.drawString(labels[i], lines[i], this.m_chart.yHorzLabels, 1);
        }
    }

    public void drawString(String s, int x, int y, int effect) {
        FontMetrics metrics = this.graphics.getFontMetrics();
        StringTokenizer tok = new StringTokenizer(s);
        while (tok.hasMoreTokens()) {
            String text = tok.nextToken();
            int xText = effect == 1 ? x - metrics.stringWidth(text) / 2 : x;
            this.graphics.drawString(text, xText, y);
            y += metrics.getAscent();
        }
    }

    public static int getStringHeight(String s, FontMetrics metrics) {
        int result = 0;
        int cTokens = new StringTokenizer(s).countTokens();
        for (int i = 0; i < cTokens; ++i) {
            result += metrics.getAscent();
        }
        return result;
    }
}

