/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.group;

import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.faces.Redirect;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.inventory.group.AbstractGroupPluginConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;

@Name(value="EditGroupPluginConfigurationUIBean")
@Scope(value=ScopeType.CONVERSATION)
public class EditGroupPluginConfigurationUIBean
extends AbstractGroupPluginConfigurationUIBean {
    public static final String VIEW_ID = "/rhq/group/inventory/edit-connection.xhtml";
    @In(value="org.jboss.seam.faces.redirect")
    private Redirect redirect;

    @Create
    @Begin
    public void init() {
        this.loadConfigurations();
        this.redirect.setParameter("groupId", (Object)this.getGroup().getId());
    }

    public void updateConfigurations() {
        try {
            this.getConfigurationSet().applyGroupConfiguration();
            this.getConfigurationManager().scheduleGroupPluginConfigurationUpdate(EnterpriseFacesContextUtility.getSubject(), this.getGroup().getId(), this.getPluginConfigurations());
        }
        catch (Exception e) {
            if (e instanceof PermissionException) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getLocalizedMessage());
                this.redirect.setViewId("/rhq/group/inventory/view-connection.xhtml");
            } else {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to schedule group plugin Configuration update - cause: " + e));
                this.redirect.setViewId(VIEW_ID);
            }
            this.redirect.execute();
            return;
        }
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Group plugin Configuration update scheduled.");
        Conversation.instance().endBeforeRedirect();
        this.redirect.setViewId("/rhq/group/inventory/connectionHistory.xhtml");
        this.redirect.execute();
    }

    @End
    public void cancel() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Edit canceled.");
        this.redirect.setViewId("/rhq/group/inventory/view-connection.xhtml");
        this.redirect.execute();
    }

    @End
    public void reset() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"All properties reset to original values.");
        this.redirect.setViewId(VIEW_ID);
        this.redirect.execute();
    }
}

