/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.composite.MeasurementOOBComposite;
import org.rhq.core.domain.operation.composite.ResourceOperationLastCompletedComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.engine.internal.Tuple;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceOverviewUIBean {
    private List<Alert> recentAlerts;
    private List<ResourceOperationLastCompletedComposite> recentOperations;
    private List<ResourceConfigurationUpdate> recentConfigChanges;
    private List<Tuple<EventSeverity, Integer>> recentEventCounts;
    private List<InstalledPackageHistory> recentPackageHistory;
    private List<MeasurementOOBComposite> recentOObs;
    private Subject subject = EnterpriseFacesContextUtility.getSubject();
    private int resourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);

    private List<Alert> getAlerts(Subject subject, int resourceId, int count) {
        PageControl lastFive = new PageControl(0, count);
        lastFive.initDefaultOrderingField("a.ctime", PageOrdering.DESC);
        return LookupUtil.getAlertManager().findAlerts(resourceId, null, null, null, null, lastFive);
    }

    private List<ResourceOperationLastCompletedComposite> getOperations(Subject subject, int resourceId, int count) {
        PageControl lastFive = new PageControl(0, count);
        lastFive.initDefaultOrderingField("ro.createdTime", PageOrdering.DESC);
        return LookupUtil.getOperationManager().findRecentlyCompletedResourceOperations(subject, Integer.valueOf(resourceId), lastFive);
    }

    private List<ResourceConfigurationUpdate> getConfigUpdates(Subject subject, int resourceId, int count) {
        PageControl lastFive = new PageControl(0, count);
        lastFive.initDefaultOrderingField("cu.createdTime", PageOrdering.DESC);
        return LookupUtil.getConfigurationManager().findResourceConfigurationUpdates(subject, Integer.valueOf(resourceId), null, null, true, lastFive);
    }

    private List<Tuple<EventSeverity, Integer>> getEventCounts(Subject subject, int resourceId) {
        PageControl unlimited = PageControl.getUnlimitedInstance();
        unlimited.initDefaultOrderingField("ev.timestamp", PageOrdering.DESC);
        long now = System.currentTimeMillis();
        long nowMinus24Hours = now - 86400000L;
        Map eventCounts = LookupUtil.getEventManager().getEventCountsBySeverity(subject, resourceId, nowMinus24Hours, now);
        ArrayList<Tuple<EventSeverity, Integer>> results = new ArrayList<Tuple<EventSeverity, Integer>>();
        for (EventSeverity severity : eventCounts.keySet()) {
            int count = (Integer)eventCounts.get(severity);
            if (count <= 0) continue;
            results.add((Tuple<EventSeverity, Integer>)new Tuple((Object)severity, (Object)count));
        }
        return results;
    }

    private List<InstalledPackageHistory> getPackageHistory(Subject subject, int resourceId, int count) {
        PageControl lastFive = new PageControl(0, count);
        lastFive.initDefaultOrderingField("iph.timestamp", PageOrdering.DESC);
        return LookupUtil.getContentUIManager().getInstalledPackageHistoryForResource(resourceId, lastFive);
    }

    private List<MeasurementOOBComposite> getRecentOObs(Subject subject, int resourceId, int n) {
        return LookupUtil.getOOBManager().getHighestNOOBsForResource(subject, resourceId, n);
    }

    public List<Alert> getRecentAlerts() {
        if (this.recentAlerts == null) {
            this.recentAlerts = this.getAlerts(this.subject, this.resourceId, 5);
        }
        return this.recentAlerts;
    }

    public List<ResourceOperationLastCompletedComposite> getRecentOperations() {
        if (this.recentOperations == null) {
            this.recentOperations = this.getOperations(this.subject, this.resourceId, 5);
        }
        return this.recentOperations;
    }

    public List<ResourceConfigurationUpdate> getRecentConfigChanges() {
        if (this.recentConfigChanges == null) {
            this.recentConfigChanges = this.getConfigUpdates(this.subject, this.resourceId, 5);
        }
        return this.recentConfigChanges;
    }

    public List<Tuple<EventSeverity, Integer>> getRecentEventCounts() {
        if (this.recentEventCounts == null) {
            this.recentEventCounts = this.getEventCounts(this.subject, this.resourceId);
        }
        return this.recentEventCounts;
    }

    public List<InstalledPackageHistory> getRecentPackageHistory() {
        if (this.recentPackageHistory == null) {
            this.recentPackageHistory = this.getPackageHistory(this.subject, this.resourceId, 5);
        }
        return this.recentPackageHistory;
    }

    public List<MeasurementOOBComposite> getRecentOOBs() {
        if (this.recentOObs == null) {
            this.recentOObs = this.getRecentOObs(this.subject, this.resourceId, 5);
        }
        return this.recentOObs;
    }
}

