/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceTypeConverter
implements Converter {
    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String string) {
        int resourceTypeId = Integer.parseInt(string);
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        try {
            ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
            ResourceType resourceType = resourceTypeManager.getResourceTypeById(subject, resourceTypeId);
            return resourceType;
        }
        catch (ResourceTypeNotFoundException e) {
            throw new RuntimeException("Error loading resource type: " + resourceTypeId, e);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object object) {
        ResourceType resourceType = (ResourceType)object;
        return Integer.toString(resourceType.getId());
    }
}

