/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.legacy.Portal;
import org.rhq.enterprise.gui.legacy.Portlet;
import org.rhq.enterprise.gui.legacy.action.resource.ResourceController;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.AlertDefUtil;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.util.LookupUtil;

public class PortalAction
extends ResourceController {
    protected static Log log = LogFactory.getLog(PortalAction.class);
    private static Properties keyMethodMap = new Properties();

    protected Properties getKeyMethodMap() {
        return keyMethodMap;
    }

    protected void setResource(HttpServletRequest request) throws Exception {
        try {
            super.setResource(request);
        }
        catch (ParameterNotFoundException e) {
            log.warn((Object)"No resource found.");
        }
    }

    private void setTitle(HttpServletRequest request, Portal portal, String titleName) throws Exception {
        Resource resource = RequestUtils.getResource((HttpServletRequest)request);
        ResourceGroup group = RequestUtils.getResourceGroupIfExists((HttpServletRequest)request);
        ResourceType type = resource != null ? resource.getResourceType() : (group != null ? group.getResourceType() : RequestUtils.getResourceType((HttpServletRequest)request));
        ResourceCategory category = type.getCategory();
        titleName = StringUtil.replace((String)titleName, (String)"platform", (String)category.toString().toLowerCase());
        portal.setName(titleName);
        try {
            AlertDefinition alertDef = AlertDefUtil.getAlertDefinition((HttpServletRequest)request);
            request.setAttribute("TitleParam2", (Object)alertDef.getName());
        }
        catch (ParameterNotFoundException e) {
            log.trace((Object)("couldn't find alert definition: " + e.getMessage()));
        }
    }

    private void setSNMPEnabled(HttpServletRequest request) throws RemoteException {
        Properties props = LookupUtil.getSystemManager().getSystemConfiguration();
        if (props.containsKey("SNMP_VERSION")) {
            String ver = props.getProperty("SNMP_VERSION");
            request.setAttribute("snmpEnabled", (Object)(ver.length() > 0 ? 1 : 0));
        }
    }

    public ActionForward newDefinition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alert.config.platform.edit.NewAlertDef.Title");
        portal.addPortlet(new Portlet(".events.config.new"), 1);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward editDefinitionProperties(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alert.config.platform.edit.page.Title");
        portal.addPortlet(new Portlet(".events.config.edit.properties"), 1);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward editDefinitionConditions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alert.config.platform.edit.condition.Title");
        portal.addPortlet(new Portlet(".events.config.edit.conditions"), 1);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward editDefinitionControlAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alerts.config.platform.EditControlAction.Title");
        portal.addPortlet(new Portlet(".events.config.edit.controlaction"), 1);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward editDefinitionSyslogAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alerts.config.platform.EditSyslogAction.Title");
        portal.addPortlet(new Portlet(".events.config.edit.syslogaction"), 1);
        portal.setDialog(true);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward viewDefinitionOthers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alert.config.platform.props.ViewDef.email.Title");
        portal.addPortlet(new Portlet(".events.config.view.others"), 1);
        request.setAttribute("portal", (Object)portal);
        this.setSNMPEnabled(request);
        return null;
    }

    public ActionForward viewDefinitionRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alert.config.platform.props.ViewDef.roles.Title");
        portal.addPortlet(new Portlet(".events.config.view.roles"), 1);
        request.setAttribute("portal", (Object)portal);
        this.setSNMPEnabled(request);
        return null;
    }

    public ActionForward viewDefinitionUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alert.config.platform.props.ViewDef.users.Title");
        portal.addPortlet(new Portlet(".events.config.view.users"), 1);
        request.setAttribute("portal", (Object)portal);
        this.setSNMPEnabled(request);
        return null;
    }

    public ActionForward viewDefinitionSNMP(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alert.config.platform.props.ViewDef.users.Title");
        portal.addPortlet(new Portlet(".events.config.view.snmp"), 1);
        request.setAttribute("portal", (Object)portal);
        this.setSNMPEnabled(request);
        return null;
    }

    public ActionForward monitorConfigureAlerts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        portal.addPortlet(new Portlet(".events.config.list"), 1);
        portal.setDialog(false);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward listDefinitions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block4: {
            this.setResource(request);
            super.setNavMapLocation(request, mapping, "alerts/Config.do");
            SessionUtils.resetReturnPath((HttpSession)request.getSession());
            try {
                this.setReturnPath(request, mapping);
            }
            catch (ParameterNotFoundException pne) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"", (Throwable)pne);
            }
        }
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alerts.config.platform.DefinitionList.Title");
        portal.setDialog(false);
        try {
            RequestUtils.getStringParameter((HttpServletRequest)request, (String)"aetid");
            portal.addPortlet(new Portlet(".admin.alerts.List"), 1);
        }
        catch (ParameterNotFoundException e) {
            portal.addPortlet(new Portlet(".events.config.list"), 1);
        }
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward addUsersDefinitions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alerts.config.platform.AssignUsersToAlertDefinition.Title");
        portal.addPortlet(new Portlet(".events.config.addusers"), 1);
        portal.setDialog(false);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward addRolesDefinitions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alerts.config.platform.AssignRolesToAlertDefinition.Title");
        portal.addPortlet(new Portlet(".events.config.addroles"), 1);
        portal.setDialog(false);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    public ActionForward addOthersDefinitions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResource(request);
        Portal portal = Portal.createPortal();
        this.setTitle(request, portal, "alerts.config.platform.AssignOthersToAlertDefinition.Title");
        portal.addPortlet(new Portlet(".events.config.addothers"), 1);
        portal.setDialog(false);
        request.setAttribute("portal", (Object)portal);
        return null;
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping) throws Exception {
        HashMap<String, Object> parms = new HashMap<String, Object>();
        int resourceId = RequestUtils.getResourceId((HttpServletRequest)request);
        parms.put("id", resourceId);
        try {
            parms.put("ad", RequestUtils.getIntParameter((HttpServletRequest)request, (String)"ad"));
            parms.put("ctype", WebUtility.getChildResourceTypeId((HttpServletRequest)request));
        }
        catch (ParameterNotFoundException pnfe) {
            log.trace((Object)("couldn't find parameter: " + pnfe.getMessage()));
        }
        String mode = request.getParameter("mode");
        parms.put("mode", mode);
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, parms);
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
    }

    static {
        keyMethodMap.setProperty("list", "listDefinitions");
        keyMethodMap.setProperty("view", "listDefinitions");
        keyMethodMap.setProperty("new", "newDefinition");
        keyMethodMap.setProperty("editProperties", "editDefinitionProperties");
        keyMethodMap.setProperty("editConditions", "editDefinitionConditions");
        keyMethodMap.setProperty("editControlAction", "editDefinitionControlAction");
        keyMethodMap.setProperty("editSyslogAction", "editDefinitionSyslogAction");
        keyMethodMap.setProperty("viewOthers", "viewDefinitionOthers");
        keyMethodMap.setProperty("viewRoles", "viewDefinitionRoles");
        keyMethodMap.setProperty("viewUsers", "viewDefinitionUsers");
        keyMethodMap.setProperty("viewSnmp", "viewDefinitionSNMP");
        keyMethodMap.setProperty("addOthers", "addOthersDefinitions");
        keyMethodMap.setProperty("addRoles", "addRolesDefinitions");
        keyMethodMap.setProperty("addUsers", "addUsersDefinitions");
    }
}

