/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.SnmpNotification;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.AlertDefUtil;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.SnmpTrapForm;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SnmpTrapFormPrepareAction
extends BaseAction {
    private Log log = LogFactory.getLog(SnmpTrapFormPrepareAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PageControl pageControl;
        SnmpTrapForm snmpTrapForm = (SnmpTrapForm)form;
        AlertDefinition alertDefinition = AlertDefUtil.getAlertDefinition((HttpServletRequest)request);
        SnmpNotification snmpNotification = this.getSnmpNotification(alertDefinition, pageControl = WebUtility.getPageControl((ServletRequest)request));
        if (snmpNotification != null) {
            snmpTrapForm.setHost(snmpNotification.getHost());
            snmpTrapForm.setPort(Integer.valueOf(snmpNotification.getPort()));
            snmpTrapForm.setOid(snmpNotification.getOid());
        }
        return null;
    }

    @Nullable
    private SnmpNotification getSnmpNotification(AlertDefinition alertDefinition, PageControl pageControl) {
        SnmpNotification snmpNotification;
        AlertNotificationManagerLocal alertNotificationManager = LookupUtil.getAlertNotificationManager();
        PageList snmpNotifications = alertNotificationManager.getSnmpNotifications(Integer.valueOf(alertDefinition.getId()), pageControl);
        if (!snmpNotifications.isEmpty()) {
            if (snmpNotifications.size() > 1) {
                this.log.warn((Object)("More than one SNMP notification found for alert definition " + alertDefinition + ", but the GUI currently only supports up to one SNMP notification per alert definition."));
            }
            snmpNotification = (SnmpNotification)snmpNotifications.get(0);
        } else {
            snmpNotification = null;
        }
        return snmpNotification;
    }
}

