/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.config;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.config.ConfigMetricsAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.config.MonitoringConfigForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.util.MetricsDisplayMode;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ConfigMetricsAction
extends BaseAction {
    private final Log log = LogFactory.getLog((String)ConfigMetricsAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"modify-metric-schedules action");
        }
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        HashMap<String, Integer> returnRequestParams = new HashMap<String, Integer>(2);
        int resourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"id", (int)-1);
        int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        int resourceTypeId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        MetricsDisplayMode mode = WebUtility.getMetricsDisplayMode((HttpServletRequest)request);
        switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
            case 1: {
                returnRequestParams.put("type", resourceTypeId);
                break;
            }
            case 2: {
                returnRequestParams.put("id", resourceId);
                break;
            }
            case 3: {
                returnRequestParams.put("groupId", groupId);
                break;
            }
            case 4: {
                returnRequestParams.put("type", resourceTypeId);
                returnRequestParams.put("parent", parent);
                break;
            }
        }
        ActionForward forward = this.checkSubmit(request, mapping, form, returnRequestParams);
        MonitoringConfigForm monitoringConfigForm = (MonitoringConfigForm)form;
        int[] measurementDefinitionIdsToUpdate = monitoringConfigForm.getMids();
        if (measurementDefinitionIdsToUpdate.length == 0) {
            return forward != null ? forward : this.returnSuccess(request, mapping, returnRequestParams);
        }
        if (forward != null) {
            if (monitoringConfigForm.isRemoveClicked()) {
                switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
                    case 1: {
                        scheduleManager.disableDefaultCollectionForMeasurementDefinitions(subject, measurementDefinitionIdsToUpdate, monitoringConfigForm.getSchedulesShouldChange());
                        break;
                    }
                    case 2: {
                        scheduleManager.disableSchedules(subject, resourceId, measurementDefinitionIdsToUpdate);
                        break;
                    }
                    case 3: {
                        scheduleManager.disableSchedulesForCompatibleGroup(subject, groupId, measurementDefinitionIdsToUpdate);
                        break;
                    }
                    case 4: {
                        scheduleManager.disableSchedulesForAutoGroup(subject, parent, resourceTypeId, measurementDefinitionIdsToUpdate);
                    }
                }
                RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.config.RemoveMetrics.Confirmation");
            }
            return forward;
        }
        long newCollectionInterval = monitoringConfigForm.getIntervalTime();
        switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
            case 1: {
                scheduleManager.updateDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIdsToUpdate, newCollectionInterval, monitoringConfigForm.getSchedulesShouldChange());
                break;
            }
            case 2: {
                scheduleManager.updateSchedules(subject, resourceId, measurementDefinitionIdsToUpdate, newCollectionInterval);
                break;
            }
            case 3: {
                scheduleManager.updateSchedulesForCompatGroup(subject, groupId, measurementDefinitionIdsToUpdate, newCollectionInterval);
                break;
            }
            case 4: {
                scheduleManager.updateSchedulesForAutoGroup(subject, parent, resourceTypeId, measurementDefinitionIdsToUpdate, newCollectionInterval);
            }
        }
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.config.ConfigMetrics.Confirmation");
        return this.returnSuccess(request, mapping, returnRequestParams);
    }
}

