/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.controlactions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewAction
extends TilesAction {
    private static final Log log = LogFactory.getLog(ViewAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean displayLastCompleted = false;
        boolean displayNextScheduled = false;
        PageList lastCompletedResourceOps = new PageList();
        PageList lastCompletedGroupOps = new PageList();
        PageList nextScheduledResourceOps = new PageList();
        PageList nextScheduledGroupOps = new PageList();
        try {
            PageControl pageControl;
            WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
            if (user == null) {
                ActionForward actionForward = null;
                return actionForward;
            }
            WebUserPreferences preferences = user.getWebPreferences();
            WebUserPreferences.OperationPortletPreferences operationPreferences = preferences.getOperationPortletPreferences();
            displayLastCompleted = operationPreferences.useLastCompleted;
            displayNextScheduled = operationPreferences.useNextScheduled;
            OperationManagerLocal manager = LookupUtil.getOperationManager();
            if (operationPreferences.useLastCompleted) {
                pageControl = new PageControl(0, operationPreferences.lastCompleted);
                pageControl.initDefaultOrderingField("ro.createdTime", PageOrdering.DESC);
                lastCompletedResourceOps = manager.findRecentlyCompletedResourceOperations(user.getSubject(), null, pageControl);
                pageControl = new PageControl(0, operationPreferences.lastCompleted);
                pageControl.initDefaultOrderingField("go.createdTime", PageOrdering.DESC);
                lastCompletedGroupOps = manager.findRecentlyCompletedGroupOperations(user.getSubject(), pageControl);
            }
            if (operationPreferences.useNextScheduled) {
                pageControl = new PageControl(0, operationPreferences.nextScheduled);
                nextScheduledResourceOps = manager.findCurrentlyScheduledResourceOperations(user.getSubject(), pageControl);
                pageControl = new PageControl(0, operationPreferences.nextScheduled);
                nextScheduledGroupOps = manager.findCurrentlyScheduledGroupOperations(user.getSubject(), pageControl);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dashboard Portlet [ControlActions] experienced an error: " + e.getMessage()), (Throwable)e);
            } else {
                log.error((Object)("Dashboard Portlet [ControlActions] experienced an error: " + e.getMessage()));
            }
        }
        finally {
            context.putAttribute("displayLastCompleted", (Object)displayLastCompleted);
            context.putAttribute("displayNextScheduled", (Object)displayNextScheduled);
            context.putAttribute("lastCompletedResource", (Object)lastCompletedResourceOps);
            context.putAttribute("lastCompletedGroup", (Object)lastCompletedGroupOps);
            context.putAttribute("nextScheduledResource", (Object)nextScheduledResourceOps);
            context.putAttribute("nextScheduledGroup", (Object)nextScheduledGroupOps);
        }
        return null;
    }
}

