/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib.display;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.rhq.enterprise.gui.legacy.taglib.display.Decorator;

class BeanSorter
implements Comparator {
    private String property;
    private Decorator dec;

    protected BeanSorter(String property, Decorator dec) {
        this.property = property;
        this.dec = dec;
    }

    public int compare(Object o1, Object o2) throws RuntimeException {
        if (this.property == null) {
            throw new NullPointerException("Null property provided which prevents BeanSorter sort");
        }
        try {
            Object p1 = null;
            Object p2 = null;
            if (this.dec != null) {
                try {
                    this.dec.initRow(o1, -1, -1);
                    p1 = PropertyUtils.getProperty((Object)this.dec, (String)this.property);
                    this.dec.initRow(o2, -1, -1);
                    p2 = PropertyUtils.getProperty((Object)this.dec, (String)this.property);
                }
                catch (Exception e) {
                    p1 = PropertyUtils.getProperty((Object)o1, (String)this.property);
                    p2 = PropertyUtils.getProperty((Object)o2, (String)this.property);
                }
            } else {
                p1 = PropertyUtils.getProperty((Object)o1, (String)this.property);
                p2 = PropertyUtils.getProperty((Object)o2, (String)this.property);
            }
            if (p1 instanceof Comparable && p2 instanceof Comparable) {
                Comparable c1 = (Comparable)p1;
                Comparable c2 = (Comparable)p2;
                return c1.compareTo(c2);
            }
            throw new RuntimeException("Object returned by property \"" + this.property + "\" is not a Comparable object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException thrown while trying to fetch property \"" + this.property + "\" during sort");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException thrown while trying to fetch property \"" + this.property + "\" during sort");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("NoSuchMethodException thrown while trying to fetch property \"" + this.property + "\" during sort");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BeanSorter) {
            if (this.property != null) {
                return this.property.equals(((BeanSorter)obj).property);
            }
            return false;
        }
        return false;
    }
}

