/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadsUIBean
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Properties getAgentVersionProperties() {
        try {
            File file = LookupUtil.getAgentManager().getAgentUpdateVersionFile();
            Properties p = new Properties();
            p.load(new FileInputStream(file));
            return p;
        }
        catch (Exception e) {
            throw new RuntimeException("Agent download information not available", e);
        }
    }

    public List<File> getConnectorDownloadFiles() throws Exception {
        File downloadDir = this.getConnectorDownloadsDir();
        File[] filesArray = downloadDir.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (filesArray != null) {
            for (File file : filesArray) {
                if (!file.isFile()) continue;
                files.add(file);
            }
        }
        return files;
    }

    private File getConnectorDownloadsDir() throws Exception {
        File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
        File downloadDir = new File(serverHomeDir, "deploy/rhq.ear/rhq-downloads/connectors");
        if (!downloadDir.exists()) {
            throw new FileNotFoundException("Missing connectors downloads directory at [" + downloadDir + "]");
        }
        return downloadDir;
    }

    private File getClientDownloadDir() throws Exception {
        File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
        File downloadDir = new File(serverHomeDir, "deploy/rhq.ear/rhq-downloads/rhq-client");
        if (!downloadDir.exists()) {
            throw new FileNotFoundException("Missing remote client download directory at [" + downloadDir + "]");
        }
        return downloadDir;
    }

    public Properties getClientVersionProperties() throws Exception {
        File versionFile = new File(this.getClientDownloadDir(), "rhq-client-version.properties");
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(versionFile));
            return p;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve client version info", e);
        }
    }
}

