/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.util.MeasurementFormatter;
import org.rhq.enterprise.server.operation.OperationManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="alertConditionUIBean")
public class AlertConditionUIBean {
    @In(value="#{webUser.subject}")
    private Subject subject;
    @In
    private ResourceType resourceType;
    @In
    private AlertDefinition alertDefinition;
    @In
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @In
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    @In
    private OperationManagerLocal operationManager;
    @In
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    @In
    private Map<String, String> messages;
    private Map<String, String> conditionExpressions;
    private Map<String, String> availabilities;
    private Map<String, String> severities;
    private Map<String, String> comparators;
    private Map<String, String> baselines;
    private Map<String, String> operationStatuses;
    private Map<String, Integer> measurements;
    private Map<String, Integer> traits;
    private Map<String, String> operations;
    private Map<String, Integer> existingAlerts;
    private Map<String, String> dampeningCategories;
    private Map<String, String> timeUnits;
    private Integer resourceId;

    public Map<String, String> getConditionExpressions() {
        return this.conditionExpressions;
    }

    public Map<String, String> getAvailabilities() {
        return this.availabilities;
    }

    public Map<String, String> getSeverities() {
        return this.severities;
    }

    public Map<String, String> getOperationStatuses() {
        return this.operationStatuses;
    }

    public Map<String, String> getComparators() {
        return this.comparators;
    }

    public Map<String, String> getBaselines() {
        return this.baselines;
    }

    public Map<String, String> getOperations() {
        return this.operations;
    }

    public Map<String, Integer> getMeasurements() {
        return this.measurements;
    }

    public Map<String, Integer> getTraits() {
        return this.traits;
    }

    public Map<String, Integer> getExistingAlerts() {
        return this.existingAlerts;
    }

    public Map<String, String> getDampeningCategories() {
        return this.dampeningCategories;
    }

    public Map<String, String> getTimeUnits() {
        return this.timeUnits;
    }

    @RequestParameter(value="id")
    public void setResourceId(Integer resourceId) {
        if (resourceId != null) {
            this.resourceId = resourceId;
        }
    }

    public Integer getResourceId() {
        if (this.alertDefinition != null && this.alertDefinition.getResource() != null) {
            return this.alertDefinition.getResource().getId();
        }
        return this.resourceId;
    }

    @Create
    public void init() {
        this.conditionExpressions = this.createBooleanMap();
        this.availabilities = this.createMap(AvailabilityType.class, "Goes ");
        this.severities = this.createMap(EventSeverity.class);
        this.operationStatuses = this.createMap(OperationRequestStatus.class);
        this.comparators = this.createComparatorMap();
        this.baselines = this.createBaselines();
        this.measurements = this.lookupMeasurements(DataType.MEASUREMENT);
        this.traits = this.lookupMeasurements(DataType.TRAIT);
        this.operations = this.lookupOperations();
        this.existingAlerts = this.lookupExistingAlerts();
        this.dampeningCategories = this.createDampeningMap();
        this.timeUnits = this.createTimeUnits();
    }

    private Map<String, String> createBooleanMap() {
        HashMap<String, String> booleanMap = new HashMap<String, String>();
        booleanMap.put(BooleanExpression.ALL.name(), BooleanExpression.ALL.name());
        booleanMap.put(BooleanExpression.ANY.name(), BooleanExpression.ANY.name());
        return booleanMap;
    }

    private Map<String, Integer> lookupExistingAlerts() {
        HashMap<String, Integer> alertsMap = new HashMap<String, Integer>();
        PageList alerts = this.alertDefinitionManager.findAlertDefinitions(this.subject, this.getResourceId().intValue(), PageControl.getUnlimitedInstance());
        for (AlertDefinition alert : alerts) {
            alertsMap.put(alert.getName(), alert.getId());
        }
        return alertsMap;
    }

    private Map<String, String> createTimeUnits() {
        HashMap<String, String> timeUnitMap = new HashMap<String, String>();
        for (AlertDampening.TimeUnits unit : AlertDampening.TimeUnits.values()) {
            String unitName = unit.name();
            timeUnitMap.put(unitName.toLowerCase(), unitName);
        }
        return timeUnitMap;
    }

    private Map<String, String> createDampeningMap() {
        HashMap<String, String> dampeningMap = new HashMap<String, String>();
        dampeningMap.put("Every Time", "NONE");
        dampeningMap.put("Every X Times Consecutively", AlertDampening.Category.CONSECUTIVE_COUNT.name());
        dampeningMap.put("Every X Out of Y Evaluations", AlertDampening.Category.PARTIAL_COUNT.name());
        dampeningMap.put("Every X Times Within a Time Duration ", AlertDampening.Category.DURATION_COUNT.name());
        return dampeningMap;
    }

    private Map<String, String> createComparatorMap() {
        HashMap<String, String> comparatorMap = new HashMap<String, String>();
        comparatorMap.put((String)this.messages.get("alert.config.props.CB.Content.Comparator.>"), ">");
        comparatorMap.put((String)this.messages.get("alert.config.props.CB.Content.Comparator.<"), "<");
        comparatorMap.put((String)this.messages.get("alert.config.props.CB.Content.Comparator.="), "=");
        return comparatorMap;
    }

    private Map<String, String> createBaselines() {
        HashMap<String, String> baselineMap = new HashMap<String, String>();
        List definitions = this.measurementDefinitionManager.findMeasurementDefinitionsByResourceType(this.subject, this.resourceType.getId(), DataType.MEASUREMENT, null);
        int[] definitionIds = new int[definitions.size()];
        for (int i = 0; i < definitionIds.length; ++i) {
            definitionIds[i] = ((MeasurementDefinition)definitions.get(i)).getId();
        }
        List schedules = this.measurementScheduleManager.findSchedulesByResourceIdAndDefinitionIds(this.subject, this.getResourceId().intValue(), definitionIds);
        for (MeasurementSchedule schedule : schedules) {
            baselineMap.put(this.getLabel("min", schedule), "min");
            baselineMap.put(this.getLabel("mean", schedule), "mean");
            baselineMap.put(this.getLabel("max", schedule), "max");
        }
        return baselineMap;
    }

    private String getLabel(String measurementConstant, MeasurementSchedule schedule) {
        return MeasurementFormatter.getBaselineText((String)measurementConstant, (MeasurementSchedule)schedule);
    }

    private Map<String, Integer> lookupMeasurements(DataType type) {
        HashMap<String, Integer> measurementMap = new HashMap<String, Integer>();
        List definitions = this.measurementDefinitionManager.findMeasurementDefinitionsByResourceType(this.subject, this.resourceType.getId(), type, null);
        for (MeasurementDefinition definition : definitions) {
            measurementMap.put(definition.getDisplayName(), definition.getId());
        }
        return measurementMap;
    }

    private Map<String, String> lookupOperations() {
        HashMap<String, String> operationMap = new HashMap<String, String>();
        List operationDefinitions = this.operationManager.findSupportedResourceTypeOperations(this.subject, this.resourceType.getId(), false);
        for (OperationDefinition operationDefinition : operationDefinitions) {
            operationMap.put(operationDefinition.getDisplayName(), operationDefinition.getName());
        }
        return operationMap;
    }

    private <T extends Enum> Map<String, String> createMap(Class<T> enumType) {
        return this.createMap(enumType, "");
    }

    private <T extends Enum> Map<String, String> createMap(Class<T> enumType, String prefix) {
        EnumSet<Enum> enumSet = EnumSet.allOf(enumType);
        HashMap<String, String> enumMap = new HashMap<String, String>(enumSet.size());
        for (Enum enumItem : enumSet) {
            enumMap.put(prefix + enumItem.name(), enumItem.toString());
        }
        return enumMap;
    }
}

