/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.enterprise.gui.alert.description.AlertConditionDescriber;
import org.rhq.enterprise.gui.alert.description.AlertDampeningDescriber;
import org.rhq.enterprise.gui.alert.description.AvailabilityDescriber;
import org.rhq.enterprise.gui.alert.description.BaselineDescriber;
import org.rhq.enterprise.gui.alert.description.ChangeOrTraitDescriber;
import org.rhq.enterprise.gui.alert.description.ControlDescriber;
import org.rhq.enterprise.gui.alert.description.DefaultDescriber;
import org.rhq.enterprise.gui.alert.description.EventDescriber;
import org.rhq.enterprise.gui.alert.description.ResourceConfigDescriber;
import org.rhq.enterprise.gui.alert.description.ThresholdDescriber;

@Name(value="alertDescriber")
@Scope(value=ScopeType.APPLICATION)
@AutoCreate
public class AlertDescriber {
    @In
    private Map<String, String> messages;
    private Map<AlertConditionCategory, AlertConditionDescriber> conditionDescribers;
    private AlertDampeningDescriber dampeningDescriber;

    @Create
    public void init() {
        AlertConditionDescriber[] describerList;
        this.dampeningDescriber = new AlertDampeningDescriber(this.messages);
        this.conditionDescribers = new HashMap();
        for (AlertConditionDescriber describer : describerList = new AlertConditionDescriber[]{new ControlDescriber(), new ResourceConfigDescriber(), new ThresholdDescriber(), new BaselineDescriber(), new ChangeOrTraitDescriber(), new EventDescriber(), new AvailabilityDescriber(), new DefaultDescriber()}) {
            describer.setTranslations(this.messages);
            for (AlertConditionCategory category : describer.getDescribedCategories()) {
                this.conditionDescribers.put(category, describer);
            }
        }
    }

    public String describeCondition(AlertCondition condition) {
        AlertConditionDescriber describer = (AlertConditionDescriber)this.conditionDescribers.get(condition.getCategory());
        if (describer != null) {
            return describer.describe(condition);
        }
        return null;
    }

    public String describeDampening(AlertDampening dampening) {
        return this.dampeningDescriber.describe(dampening);
    }
}

