/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.alert.notification.NotificationTemplate;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.gui.alert.AlertNotificationStore;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="alertNotificationTemplateStore")
public class AlertNotificationTemplateStore
implements AlertNotificationStore,
Serializable {
    @In
    private AlertNotificationManagerLocal alertNotificationManager;
    private NotificationTemplate template;

    public void setNotificationTemplate(NotificationTemplate template) {
        this.template = template;
    }

    public List<AlertNotification> lookupNotifications(Subject subject) {
        if (this.template != null) {
            return this.alertNotificationManager.getNotificationsForTemplate(subject, this.template.getId());
        }
        return null;
    }

    public AlertNotification addNotification(Subject subject, String senderType, String notificationName, Configuration configuration) {
        if (this.template != null) {
            return this.alertNotificationManager.addAlertNotificationToTemplate(subject, this.template.getName(), senderType, notificationName, configuration);
        }
        return null;
    }

    public void removeNotifications(Subject subject, Integer[] notificationIds) {
        if (this.template != null) {
            this.alertNotificationManager.removeNotificationsFromTemplate(subject, this.template.getId(), notificationIds);
        }
    }
}

