/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.enterprise.gui.alert.AlertDescriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="alertUIBean")
public class AlertUIBean
implements Serializable {
    @In
    private AlertDescriber alertDescriber;
    @In
    private AlertDefinition alertDefinition;
    @In
    private EntityManager entityManager;
    private List<String> alertConditions;
    private String alertDampening;

    public String getAlertDampening() {
        return this.alertDampening;
    }

    public AlertDefinition getAlertDefinition() {
        return this.alertDefinition;
    }

    public void setAlertDefinition(AlertDefinition alertDefinition) {
        this.alertDefinition = alertDefinition;
    }

    public List<String> getAlertConditions() {
        return this.alertConditions;
    }

    public String saveAlertDefinition() {
        AlertDefinition def = (AlertDefinition)this.entityManager.merge((Object)this.alertDefinition);
        this.entityManager.persist((Object)def);
        return null;
    }

    @Create
    public void init() {
        this.alertConditions = this.lookupAlertConditions();
        this.alertDampening = this.lookupAlertDampening();
    }

    private List<String> lookupAlertConditions() {
        ArrayList<String> conditions = new ArrayList<String>();
        for (AlertCondition condition : this.alertDefinition.getConditions()) {
            conditions.add(this.alertDescriber.describeCondition(condition));
        }
        return conditions;
    }

    private String lookupAlertDampening() {
        AlertDampening dampening = this.alertDefinition.getAlertDampening();
        return this.alertDescriber.describeDampening(dampening);
    }
}

