/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;

@Scope(value=ScopeType.PAGE)
@Name(value="customContentUIBean")
public class CustomContentUIBean {
    @RequestParameter
    private String senderName;
    @RequestParameter(value="nid")
    private Integer notificationId;
    @In
    private AlertNotificationManagerLocal alertNotificationManager;
    @In(value="#{webUser.subject}")
    private Subject subject;
    private String contentUrl;

    public String getContentUrl() {
        return this.contentUrl;
    }

    @Create
    public void init() {
        AlertSenderInfo info = this.alertNotificationManager.getAlertInfoForSender(this.senderName);
        if (info != null && info.getUiSnippetUrl() != null) {
            this.contentUrl = info.getUiSnippetUrl().toString();
        }
        String backingBeanName = this.alertNotificationManager.getBackingBeanNameForSender(this.senderName);
        CustomAlertSenderBackingBean backingBean = this.alertNotificationManager.getBackingBeanForSender(this.senderName, this.notificationId);
        if (backingBeanName != null && backingBean != null) {
            backingBean.setWebUser(this.subject);
            this.outjectBean(backingBeanName, backingBean);
        }
    }

    private void outjectBean(String name, CustomAlertSenderBackingBean bean) {
        Context context = Contexts.getSessionContext();
        CustomAlertSenderBackingBean csb = (CustomAlertSenderBackingBean)context.get(name);
        if (csb == null) {
            context.set(name, (Object)bean);
        }
    }
}

