/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.domain.alert.notification.NotificationTemplate;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.alert.AlertNotificationTemplateStore;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.richfaces.model.selection.SimpleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="notificationTemplatesUIBean")
public class NotificationTemplatesUIBean
implements Serializable {
    private static final String SUCESS_OUTCOME = "success";
    @RequestParameter(value="tid")
    private Integer templateId;
    @In(value="#{webUser.subject}")
    private Subject subject;
    @In
    private AlertNotificationManagerLocal alertNotificationManager;
    @In
    private AlertNotificationTemplateStore alertNotificationTemplateStore;
    private String newTemplateName;
    private String newTemplateDescription;
    private List<NotificationTemplate> notificationTemplates;
    private SimpleSelection selectedTemplates;
    private Integer selectedTemplateId;

    public String getSelectedTemplateId() {
        if (this.selectedTemplateId != null) {
            return this.selectedTemplateId.toString();
        }
        return null;
    }

    public String getNewTemplateName() {
        return this.newTemplateName;
    }

    public void setNewTemplateName(String newTemplateName) {
        this.newTemplateName = newTemplateName;
    }

    public String getNewTemplateDescription() {
        return this.newTemplateDescription;
    }

    public void setNewTemplateDescription(String newTemplateDescription) {
        this.newTemplateDescription = newTemplateDescription;
    }

    public SimpleSelection getSelectedTemplates() {
        return this.selectedTemplates;
    }

    public void setSelectedTemplates(SimpleSelection selectedTemplates) {
        this.selectedTemplates = selectedTemplates;
    }

    public List<NotificationTemplate> getNotificationTemplates() {
        return this.notificationTemplates;
    }

    @Create
    public void initNotificationTemplates() {
        this.selectedTemplates = new SimpleSelection();
        this.notificationTemplates = this.alertNotificationManager.listNotificationTemplates(this.subject);
        this.selectActiveTemplate();
    }

    private void selectActiveTemplate() {
        if (this.templateId != null) {
            this.selectedTemplateId = this.templateId;
            for (int i = 0; i < this.notificationTemplates.size(); ++i) {
                NotificationTemplate template = (NotificationTemplate)this.notificationTemplates.get(i);
                if (template.getId() != this.templateId.intValue()) continue;
                this.selectedTemplates.addKey((Object)i);
                this.alertNotificationTemplateStore.setNotificationTemplate(template);
                return;
            }
        }
    }

    public String createNotificationTemplate() {
        try {
            NotificationTemplate template = this.alertNotificationManager.createNotificationTemplate(this.newTemplateName, this.newTemplateDescription, new ArrayList(), true);
            this.selectedTemplateId = template.getId();
        }
        catch (IllegalArgumentException iae) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Creation of template failed: " + iae.getMessage()));
        }
        return SUCESS_OUTCOME;
    }

    public String deleteNotificationTemplate() {
        int numDeleted = this.alertNotificationManager.deleteNotificationTemplates(this.subject, this.getSelectedIds());
        String summary = this.getDeletionSummary(numDeleted);
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)summary);
        return null;
    }

    private Integer[] getSelectedIds() {
        ArrayList<Integer> selectedIds = new ArrayList<Integer>(this.selectedTemplates.size());
        for (NotificationTemplate template : this.getSelectedTemplateList()) {
            selectedIds.add(template.getId());
        }
        return selectedIds.toArray(new Integer[selectedIds.size()]);
    }

    private String getDeletionSummary(int numberDeleted) {
        StringBuilder builder = new StringBuilder("Deleted ");
        builder.append(numberDeleted);
        builder.append(" template");
        if (numberDeleted != 1) {
            builder.append("s");
        }
        return builder.toString();
    }

    public String editNotificationTemplate() {
        List selected = this.getSelectedTemplateList();
        if (selected.size() == 1) {
            this.selectedTemplateId = ((NotificationTemplate)selected.get(0)).getId();
            return SUCESS_OUTCOME;
        }
        return null;
    }

    private List<NotificationTemplate> getSelectedTemplateList() {
        ArrayList<NotificationTemplate> templateList = new ArrayList<NotificationTemplate>(this.selectedTemplates.size());
        Iterator rowKeys = this.selectedTemplates.getKeys();
        while (rowKeys.hasNext()) {
            Integer row = (Integer)rowKeys.next();
            templateList.add((NotificationTemplate)this.notificationTemplates.get(row));
        }
        return templateList;
    }
}

