/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;

@AutoCreate
@Scope(value=ScopeType.PAGE)
@Name(value="resourceType")
public class ResourceTypeComponent {
    @RequestParameter(value="id")
    private Integer resourceId;
    @In(value="#{webUser.subject}")
    private Subject subject;
    @In
    private ResourceManagerLocal resourceManager;
    @In
    private AlertDefinition alertDefinition;
    private ResourceType resourceType;

    @Unwrap
    public ResourceType lookupResourceType() {
        Resource resource;
        if (this.alertDefinition.getResource() != null) {
            this.resourceType = this.alertDefinition.getResource().getResourceType();
        } else if (this.alertDefinition.getResourceGroup() != null) {
            this.resourceType = this.alertDefinition.getResourceGroup().getResourceType();
        } else if (this.resourceId != null && (resource = this.resourceManager.getResource(this.subject, this.resourceId.intValue())) != null) {
            this.resourceType = resource.getResourceType();
        }
        return this.resourceType;
    }
}

