/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert.description;

import java.text.MessageFormat;
import java.util.Map;
import org.rhq.core.domain.alert.AlertDampening;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertDampeningDescriber {
    private static final String TIME_UNIT_PREFIX = "alert.config.props.CB.Enable.TimeUnit.";
    private static final String DAMPEN_PREFIX = "alert.config.props.CB.Dampen";
    private Map<String, String> translations;

    public AlertDampeningDescriber(Map<String, String> translations) {
        this.translations = translations;
    }

    public String describe(AlertDampening dampening) {
        int howLong = dampening.getPeriod();
        String howLongUnits = this.translate(TIME_UNIT_PREFIX + dampening.getPeriodUnits(), new Object[0]);
        int howMany = dampening.getValue();
        String howManyUnits = this.translate(TIME_UNIT_PREFIX + dampening.getValueUnits(), new Object[0]);
        String enableActionResource = DAMPEN_PREFIX + this.toCamelCase(dampening.getCategory());
        return this.translate(enableActionResource, new Object[]{howLong, howLongUnits, howMany, howManyUnits});
    }

    private String translate(String key, Object ... params) {
        String message = (String)this.translations.get(key);
        if (params.length == 0) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    private String toCamelCase(AlertDampening.Category category) {
        StringBuilder categoryName = new StringBuilder(category.name().toLowerCase());
        String first = "" + categoryName.charAt(0);
        categoryName.replace(0, 1, first.toUpperCase());
        int index = categoryName.indexOf("_");
        while (index > -1) {
            String after = "" + categoryName.charAt(index + 1);
            categoryName.replace(index, index + 2, after.toUpperCase());
            index = categoryName.indexOf("_");
        }
        return categoryName.toString();
    }
}

