/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert.description;

import org.jboss.seam.Component;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.gui.alert.description.AlertConditionDescriber;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ControlDescriber
extends AlertConditionDescriber {
    public AlertConditionCategory[] getDescribedCategories() {
        return this.makeCategories(new AlertConditionCategory[]{AlertConditionCategory.CONTROL});
    }

    public void createDescription(AlertCondition condition, StringBuilder builder) {
        OperationDefinition definition = this.getDefinition(condition);
        if (definition != null) {
            builder.append(definition.getDisplayName());
        } else {
            builder.append(condition.getName());
        }
        builder.append(' ');
        builder.append(condition.getOption());
    }

    private OperationDefinition getDefinition(AlertCondition condition) {
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        ResourceType resourceType = (ResourceType)Component.getInstance((String)"resourceType");
        String operationName = condition.getName();
        try {
            return operationManager.getOperationDefinitionByResourceTypeAndName(resourceType.getId(), operationName, false);
        }
        catch (Exception e) {
            return null;
        }
    }
}

