/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert.description;

import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.util.MeasurementConverter;
import org.rhq.enterprise.gui.alert.description.AlertConditionDescriber;

public class ThresholdDescriber
extends AlertConditionDescriber {
    public AlertConditionCategory[] getDescribedCategories() {
        return this.makeCategories(new AlertConditionCategory[]{AlertConditionCategory.THRESHOLD});
    }

    public void createDescription(AlertCondition condition, StringBuilder builder) {
        builder.append(condition.getName());
        builder.append(' ');
        builder.append(condition.getComparator());
        builder.append(' ');
        builder.append(this.getMeasurementDescription(condition));
    }

    private String getMeasurementDescription(AlertCondition condition) {
        double threshold = condition.getThreshold();
        MeasurementUnits units = condition.getMeasurementDefinition().getUnits();
        return MeasurementConverter.format((Double)threshold, (MeasurementUnits)units, (boolean)true);
    }
}

