/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.framework;

import com.sun.facelets.Facelet;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.rhq.core.util.maven.MavenArtifactNotFoundException;
import org.rhq.core.util.maven.MavenArtifactProperties;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ServerInfoUIBean {
    private static final String UNKNOWN_VERSION = "UNKNOWN";
    private final Log log = LogFactory.getLog(this.getClass());

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public boolean isDebugModeEnabled() {
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        return Boolean.valueOf(systemManager.getSystemConfiguration().getProperty("ENABLE_DEBUG_MODE"));
    }

    public String getFacesVersion() {
        return this.getManifestVersion(UIComponent.class);
    }

    public String getFaceletsVersion() {
        return this.getManifestVersion(Facelet.class);
    }

    public String getSeamVersion() {
        return this.getManifestVersion(Component.class);
    }

    public String getRichFacesVersion() {
        MavenArtifactProperties richFacesMavenProps;
        try {
            richFacesMavenProps = MavenArtifactProperties.getInstance((String)"org.richfaces.framework", (String)"richfaces-api");
        }
        catch (MavenArtifactNotFoundException e) {
            this.log.error((Object)"Could not ascertain RichFaces version.", (Throwable)e);
            richFacesMavenProps = null;
        }
        String richFacesVersion = richFacesMavenProps != null ? richFacesMavenProps.getVersion() : null;
        return richFacesVersion != null ? richFacesVersion : UNKNOWN_VERSION;
    }

    private String getManifestVersion(Class clazz) {
        String version = null;
        try {
            Package pkg = clazz.getPackage();
            if (pkg != null && (version = pkg.getImplementationVersion()) == null) {
                version = pkg.getSpecificationVersion();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error while looking up manifest version for " + clazz + "."), (Throwable)e);
        }
        return version;
    }
}

