/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.paging;

import java.util.Collection;
import java.util.List;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.resource.composite.ResourceNamesDisambiguationResult;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.common.paging.PagedListDataModel;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceNameDisambiguatingPagedListDataModel<T>
extends PagedListDataModel<DisambiguationReport<T>> {
    private boolean currentPageNeedsTypeResolution;
    private boolean currentPageNeedsPluginResolution;
    private boolean currentPageNeedsParentResolution;
    private boolean alwaysIncludeParents;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public ResourceNameDisambiguatingPagedListDataModel(PageControlView view, String beanName, boolean alwaysIncludeParents) {
        super(view, beanName);
        this.alwaysIncludeParents = alwaysIncludeParents;
    }

    public PageList<DisambiguationReport<T>> fetchPage(PageControl pc) {
        PageList data = this.fetchDataForPage(pc);
        ResourceNamesDisambiguationResult disambiguation = this.resourceManager.disambiguate((List)data, this.alwaysIncludeParents, this.getResourceIdExtractor());
        this.currentPageNeedsParentResolution = disambiguation.isParentResolutionNeeded();
        this.currentPageNeedsPluginResolution = disambiguation.isPluginResolutionNeeded();
        this.currentPageNeedsTypeResolution = disambiguation.isTypeResolutionNeeded();
        return new PageList((Collection)disambiguation.getResolution(), data.getTotalSize(), data.getPageControl());
    }

    public boolean isCurrentPageNeedsParentResolution() {
        return this.currentPageNeedsParentResolution;
    }

    public boolean isCurrentPageNeedsPluginResolution() {
        return this.currentPageNeedsPluginResolution;
    }

    public boolean isCurrentPageNeedsTypeResolution() {
        return this.currentPageNeedsTypeResolution;
    }

    protected abstract PageList<T> fetchDataForPage(PageControl var1);

    protected abstract IntExtractor<T> getResourceIdExtractor();
}

