/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceAvailabilitySummary;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.composite.ResourcePermission;
import org.rhq.core.template.TemplateEngine;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.perspective.PerspectiveManagerLocal;
import org.rhq.enterprise.server.perspective.Tab;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUIBean {
    protected final Log log = LogFactory.getLog(ResourceUIBean.class);
    public static final String MANAGED_BEAN_NAME = "ResourceUIBean";
    private Resource resource;
    private Resource parent;
    private ResourcePermission permissions;
    private ResourceFacets facets;
    private List<Tab> tabs;
    private ResourceError invalidPluginConfigurationError;
    private ResourceAvailabilitySummary availabilitySummary;
    private AvailabilityType availabilityType;
    private boolean canShowParent = false;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
    private PerspectiveManagerLocal perspectiveManager = LookupUtil.getPerspectiveManager();
    private String message;
    TemplateEngine templateEngine;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ResourceUIBean() {
        this(EnterpriseFacesContextUtility.getResource());
        this.log.debug((Object)("Creating " + ResourceUIBean.class.getSimpleName()));
    }

    public ResourceUIBean(Resource resource) {
        this(resource, EnterpriseFacesContextUtility.getSubject());
    }

    public ResourceUIBean(Resource resource, Subject subject) {
        List errors;
        this.resource = resource;
        this.parent = this.resourceManager.getParentResource(this.resource.getId());
        Set resourcePerms = this.authorizationManager.getImplicitResourcePermissions(subject, this.resource.getId());
        this.permissions = new ResourcePermission(resourcePerms);
        this.facets = this.resourceTypeManager.getResourceFacets(this.getResourceType().getId());
        this.tabs = this.perspectiveManager.getResourceTabs(subject, this.resource);
        if (this.parent != null) {
            this.canShowParent = this.authorizationManager.canViewResource(subject, this.parent.getId());
        }
        if ((errors = this.resourceManager.findResourceErrors(subject, this.resource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION)).size() == 1) {
            this.invalidPluginConfigurationError = (ResourceError)errors.get(0);
        }
    }

    public int getId() {
        return this.resource.getId();
    }

    public String getUuid() {
        return this.resource.getUuid();
    }

    @NotNull
    public String getName() {
        return this.resource.getName();
    }

    public String getResourceKey() {
        return this.resource.getResourceKey();
    }

    public ResourceType getResourceType() {
        return this.resource.getResourceType();
    }

    public InventoryStatus getInventoryStatus() {
        return this.resource.getInventoryStatus();
    }

    public boolean isConnected() {
        return this.resource.isConnected();
    }

    public String getVersion() {
        return this.resource.getVersion();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public long getCtime() {
        return this.resource.getCtime();
    }

    public long getMtime() {
        return this.resource.getMtime();
    }

    public Subject getModifiedBy() {
        return this.resource.getModifiedBy();
    }

    public String getLocation() {
        return this.resource.getLocation();
    }

    public Resource getParent() {
        return this.parent;
    }

    public ResourcePermission getPermissions() {
        return this.permissions;
    }

    public ResourceFacets getFacets() {
        return this.facets;
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    @Nullable
    public ResourceError getInvalidPluginConfigurationError() {
        return this.invalidPluginConfigurationError;
    }

    public AvailabilityType getAvailabilityType() {
        if (this.availabilityType == null) {
            AvailabilityManagerLocal manager = LookupUtil.getAvailabilityManager();
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.availabilityType = manager.getCurrentAvailabilityTypeForResource(subject, this.getId());
        }
        return this.availabilityType;
    }

    public ResourceAvailabilitySummary getAvailabilitySummary() {
        if (this.availabilitySummary == null) {
            this.availabilitySummary = this.resourceManager.getAvailabilitySummary(EnterpriseFacesContextUtility.getSubject(), this.getId());
        }
        return this.availabilitySummary;
    }

    public boolean isCanShowParent() {
        return this.canShowParent;
    }

    public TemplateEngine getTemplateEngine() {
        try {
            if (null == this.templateEngine) {
                Subject subject = EnterpriseFacesContextUtility.getSubject();
                Resource platform = this.resourceManager.getPlaformOfResource(subject, this.resource.getId());
                MeasurementDataManagerLocal measurementDataManager = LookupUtil.getMeasurementDataManager();
                List traits = measurementDataManager.findCurrentTraitsForResource(subject, platform.getId(), null);
                HashMap<String, String> tokens = new HashMap<String, String>();
                for (MeasurementDataTrait data : traits) {
                    String name = data.getName().toLowerCase().replace(' ', '_');
                    tokens.put("rhq.system." + name, data.getValue().toString());
                }
                this.templateEngine = new TemplateEngine(tokens);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Cannot fetch data for template engine", t);
        }
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }
}

