/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;
import org.rhq.core.domain.measurement.util.MeasurementConverter;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricDisplayRangeAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricDisplayRangeForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricRange;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.ViewChartForm;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewChartAction
extends MetricDisplayRangeAction {
    private final Log log = LogFactory.getLog((String)ViewChartAction.class.getName());
    MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
    MeasurementBaselineManagerLocal baselineManager = LookupUtil.getMeasurementBaselineManager();
    ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward retVal;
        ViewChartForm chartForm = (ViewChartForm)form;
        Subject subject = SessionUtils.getWebUser((HttpSession)request.getSession()).getSubject();
        Integer[] resourceIds = chartForm.getResourceIds();
        HashMap<String, Object> forwardParams = new HashMap<String, Object>(3);
        if (null != chartForm.getCtype() && chartForm.getCtype() != -1) {
            forwardParams.put("ctype", chartForm.getCtype());
        } else {
            forwardParams.put("mode", chartForm.getMode());
        }
        if (chartForm.getSaveChart()) {
            ActionForward success = this.returnRedraw(request, mapping, forwardParams);
            HashMap<String, Object> chartParams = new HashMap<String, Object>();
            chartParams.put("m", chartForm.getM());
            chartParams.put("showPeak", chartForm.getShowPeak());
            chartParams.put("showHighRange", chartForm.getShowHighRange());
            chartParams.put("showValues", chartForm.getShowValues());
            chartParams.put("showAverage", chartForm.getShowAverage());
            chartParams.put("showLowRange", chartForm.getShowLowRange());
            chartParams.put("showLow", chartForm.getShowLow());
            chartParams.put("showBaseline", chartForm.getShowBaseline());
            chartParams.put("threshold", chartForm.getThreshold());
            if (chartForm.getGroupId() > 0) {
                chartParams.put("groupId", chartForm.getGroupId());
                chartParams.put("mode", chartForm.getMode());
            } else if (chartForm.getParent() > 0 && chartForm.getCtype() > 0) {
                chartParams.put("parent", chartForm.getParent());
                chartParams.put("type", chartForm.getCtype());
                chartParams.put("mode", chartForm.getMode());
            } else if (chartForm.getId() != null) {
                chartParams.put("id", chartForm.getId());
            }
            String url = ActionUtils.changeUrl((String)success.getPath(), chartParams);
            boolean changed = this._saveUserChart(url, chartForm.getChartName(), request);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Saving chart to dashboard ...\n\tchartName=" + chartForm.getChartName() + "\n\turl=" + url));
            }
            if (changed) {
                RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.confirm.ChartSaved");
            } else {
                RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.confirm.ChartAlreadySaved");
            }
            return success;
        }
        if (chartForm.isChangeBaselineClicked()) {
            request.setAttribute("editBaseline", (Object)Boolean.TRUE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isSaveBaselineClicked()) {
            Boolean baselineWasNull = null;
            if (chartForm.getMode().equals("chartSingleMetricSingleResource")) {
                MeasurementSchedule schedule = this.scheduleManager.getSchedule(subject, chartForm.getId().intValue(), chartForm.getM()[0].intValue(), true);
                baselineWasNull = schedule.getBaseline() == null;
                this.baselineManager.calculateAutoBaseline(subject, Integer.valueOf(schedule.getId()), chartForm.getStartDate().getTime(), chartForm.getEndDate().getTime(), true);
            } else if (chartForm.getMode().equals("chartSingleMetricMultiResource")) {
                MeasurementBaseline baselineIfEqual = this.baselineManager.getBaselineIfEqual(subject, chartForm.getGroupId(), chartForm.getM()[0].intValue());
                baselineWasNull = baselineIfEqual == null;
                this.baselineManager.calculateAutoBaseline(subject, chartForm.getGroupId(), chartForm.getM()[0].intValue(), chartForm.getStartDate().getTime(), chartForm.getEndDate().getTime(), true);
            }
            request.setAttribute("editBaseline", (Object)Boolean.FALSE);
            request.setAttribute("justSavedBaseline", (Object)Boolean.TRUE);
            request.setAttribute("baselineWasNull", (Object)baselineWasNull);
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.confirm.BaselineSet");
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isCancelBaselineClicked()) {
            request.setAttribute("editBaseline", (Object)Boolean.FALSE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isChangeHighRangeClicked()) {
            request.setAttribute("editHighRange", (Object)Boolean.TRUE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isSaveHighRangeClicked()) {
            if (chartForm.getMode().equals("chartSingleMetricSingleResource")) {
                int definitionId = chartForm.getM()[0];
                int resourceId = chartForm.getId();
                boolean success = this.setBaselineMax(subject, request, resourceId, definitionId, chartForm.getHighRange());
                if (!success) {
                    return this.returnFailure(request, mapping, forwardParams);
                }
            } else if (chartForm.getMode().equals("chartSingleMetricMultiResource")) {
                int groupId = chartForm.getGroupId();
                int definitionId = chartForm.getM()[0];
                List groupMemberIds = this.resourceManager.findImplicitResourceIdsByResourceGroup(groupId);
                Iterator i$ = groupMemberIds.iterator();
                while (i$.hasNext()) {
                    int resourceMemberId = (Integer)i$.next();
                    boolean success = this.setBaselineMax(subject, request, resourceMemberId, definitionId, chartForm.getHighRange());
                    if (success) continue;
                    return this.returnFailure(request, mapping, forwardParams);
                }
            }
            request.setAttribute("editHighRange", (Object)Boolean.FALSE);
            request.setAttribute("justSavedHighRange", (Object)Boolean.TRUE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isCancelHighRangeClicked()) {
            request.setAttribute("editHighRange", (Object)Boolean.FALSE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isChangeLowRangeClicked()) {
            request.setAttribute("editLowRange", (Object)Boolean.TRUE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isSaveLowRangeClicked()) {
            if (chartForm.getMode().equals("chartSingleMetricSingleResource")) {
                int definitionId = chartForm.getM()[0];
                int resourceId = chartForm.getId();
                boolean success = this.setBaselineMin(subject, request, resourceId, definitionId, chartForm.getLowRange());
                if (!success) {
                    return this.returnFailure(request, mapping, forwardParams);
                }
            } else if (chartForm.getMode().equals("chartSingleMetricMultiResource")) {
                int groupId = chartForm.getGroupId();
                int definitionId = chartForm.getM()[0];
                List groupMemberIds = this.resourceManager.findImplicitResourceIdsByResourceGroup(groupId);
                Iterator i$ = groupMemberIds.iterator();
                while (i$.hasNext()) {
                    int resourceMemberId = (Integer)i$.next();
                    boolean success = this.setBaselineMax(subject, request, resourceMemberId, definitionId, chartForm.getLowRange());
                    if (success) continue;
                    return this.returnFailure(request, mapping, forwardParams);
                }
            }
            request.setAttribute("editLowRange", (Object)Boolean.FALSE);
            request.setAttribute("justSavedLowRange", (Object)Boolean.TRUE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isCancelLowRangeClicked()) {
            request.setAttribute("editLowRange", (Object)Boolean.FALSE);
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (chartForm.isPrevPageClicked()) {
            return this.returnSuccess(request, mapping, forwardParams);
        }
        if (chartForm.isNextRangeClicked() || chartForm.isPrevRangeClicked()) {
            MetricRange range = new MetricRange();
            if (chartForm.isNextRangeClicked()) {
                long newBegin = chartForm.getEndDate().getTime();
                long diff = newBegin - chartForm.getStartDate().getTime();
                long newEnd = newBegin + diff;
                range.setBegin(Long.valueOf(newBegin));
                range.setEnd(Long.valueOf(newEnd));
            } else if (chartForm.isPrevRangeClicked()) {
                long newEnd = chartForm.getStartDate().getTime();
                long diff = chartForm.getEndDate().getTime() - newEnd;
                long newBegin = newEnd - diff;
                range.setBegin(Long.valueOf(newBegin));
                range.setEnd(Long.valueOf(newEnd));
            }
            chartForm.setA(MetricDisplayRangeForm.ACTION_DATE_RANGE);
            chartForm.populateStartDate(new Date(range.getBegin()), request.getLocale());
            chartForm.populateEndDate(new Date(range.getEnd()), request.getLocale());
            range.shiftNow();
            request.setAttribute("metricRange", (Object)range);
        }
        if ((retVal = super.execute(mapping, form, request, response)).getName().equals("success")) {
            return this.returnRedraw(request, mapping, forwardParams);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("returning " + retVal.getName()));
        }
        return retVal;
    }

    private boolean setBaselineMax(Subject subject, HttpServletRequest request, int resourceId, int definitionId, String highRangeStr) throws Exception {
        MeasurementSchedule schedule = this.scheduleManager.getSchedule(subject, resourceId, definitionId, true);
        if (highRangeStr.length() > 0) {
            try {
                double highRange = MeasurementConverter.parse((String)highRangeStr, (MeasurementSchedule)schedule).getValue();
                MeasurementBaseline baseline = schedule.getBaseline();
                if (baseline != null) {
                    if (null != baseline.getMin() && highRange <= baseline.getMin()) {
                        RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.error.HighGreaterLow", (String)"highRange");
                        request.setAttribute("editHighRange", (Object)Boolean.TRUE);
                        return false;
                    }
                } else {
                    baseline = new MeasurementBaseline();
                    baseline.setSchedule(schedule);
                }
                baseline.setMax(Double.valueOf(highRange));
                baseline.setUserEntered(true);
                RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.confirm.HighRangeSet");
            }
            catch (MeasurementConversionException mce) {
                RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.error.RangeParseException", (String)"highRange");
                request.setAttribute("editHighRange", (Object)Boolean.TRUE);
                return false;
            }
        } else {
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.confirm.HighRangeCleared");
        }
        this.scheduleManager.updateSchedule(subject, schedule);
        return true;
    }

    private boolean setBaselineMin(Subject subject, HttpServletRequest request, int resourceId, int definitionId, String lowRangeStr) throws Exception {
        MeasurementSchedule schedule = this.scheduleManager.getSchedule(subject, resourceId, definitionId, true);
        if (lowRangeStr.length() > 0) {
            try {
                double lowRange = MeasurementConverter.parse((String)lowRangeStr, (MeasurementSchedule)schedule).getValue();
                MeasurementBaseline baseline = schedule.getBaseline();
                if (baseline != null) {
                    if (null != baseline.getMax() && lowRange >= baseline.getMax()) {
                        RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.error.HighGreaterLow", (String)"lowRange");
                        request.setAttribute("editLowRange", (Object)Boolean.TRUE);
                        return false;
                    }
                } else {
                    baseline = new MeasurementBaseline();
                    baseline.setSchedule(schedule);
                }
                baseline.setMin(Double.valueOf(lowRange));
                baseline.setUserEntered(true);
                RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.confirm.LowRangeSet");
            }
            catch (MeasurementConversionException mce) {
                RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.error.RangeParseException", (String)"lowRange");
                request.setAttribute("editLowRange", (Object)Boolean.TRUE);
                return false;
            }
        } else {
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.common.monitor.visibility.chart.confirm.LowRangeCleared");
        }
        this.scheduleManager.updateSchedule(subject, schedule);
        return true;
    }

    public ActionForward returnRedraw(HttpServletRequest request, ActionMapping mapping, Map params) throws Exception {
        return this.constructForward(request, mapping, "redraw", params, false);
    }

    private static String forHTMLTag(String aTagFragment) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aTagFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            switch (character) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    result.append("&#039;");
                    break;
                }
                case '\\': {
                    result.append("&#092;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '|': {
                    result.append("&#124;");
                    break;
                }
                case ',': {
                    result.append("&#44;");
                    break;
                }
                default: {
                    result.append(character);
                }
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private boolean _saveUserChart(String url, String name, HttpServletRequest request) throws Exception {
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        WebUserPreferences preferences = user.getWebPreferences();
        WebUserPreferences.SavedChartsPortletPreferences savedCharts = preferences.getSavedChartsPortletPreferences();
        boolean changed = savedCharts.add(name, url);
        if (changed) {
            preferences.setSavedChartsPortletPreferences(savedCharts);
        }
        return changed;
    }
}

