/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.io.IOException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.composite.LockedResource;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.UITree;
import org.richfaces.component.html.HtmlTree;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.event.NodeExpandedEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeRowKey;

public class ResourceTreeStateAdvisor
implements TreeStateAdvisor {
    private boolean altered = false;
    UITree tree;
    private TreeRowKey selectedKey;
    private int selectedId;
    private int selecteAGTypeId;
    private boolean hasMessages = false;
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public void changeExpandListener(NodeExpandedEvent e) {
        this.altered = true;
        Object source = e.getSource();
        HtmlTree c = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)c.getComponentState();
        TreeRowKey key = (TreeRowKey)c.getRowKey();
    }

    public void nodeSelectListener(NodeSelectedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        try {
            tree.queueNodeExpand((TreeRowKey)tree.getRowKey());
            ResourceTreeNode node = (ResourceTreeNode)tree.getRowData(tree.getRowKey());
            if (node != null) {
                ServletContext context = (ServletContext)FacesContextUtility.getFacesContext().getExternalContext().getContext();
                HttpServletResponse response = (HttpServletResponse)FacesContextUtility.getFacesContext().getExternalContext().getResponse();
                Subject subject = EnterpriseFacesContextUtility.getSubject();
                if (node.getData() instanceof LockedResource) {
                    state.setSelected(e.getOldSelection());
                    FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "You have not been granted view access to this resource", null));
                    return;
                }
                if (node.getData() instanceof Resource) {
                    String path = FacesContextUtility.getRequest().getRequestURI();
                    Resource resource = this.resourceManager.getResourceById(subject, ((Resource)node.getData()).getId());
                    ResourceFacets facets = this.resourceTypeManager.getResourceFacets(resource.getResourceType().getId());
                    String fallbackPath = FunctionTagLibrary.getDefaultResourceTabURL();
                    if (!path.startsWith("/rhq/resource")) {
                        path = fallbackPath;
                    } else if (path.startsWith("/rhq/resource/configuration/") && !facets.isConfiguration() || path.startsWith("/rhq/resource/content/") && !facets.isContent() || path.startsWith("/rhq/resource/operation") && !facets.isOperation() || path.startsWith("/rhq/resource/events") && !facets.isEvent()) {
                        path = fallbackPath;
                    } else if (path.startsWith("/rhq/resource/configuration/view-map.xhtml") || path.startsWith("/rhq/resource/configuration/edit-map.xhtml") || path.startsWith("/rhq/resource/configuration/add-map.xhtml") || path.startsWith("/rhq/resource/configuration/edit.xhtml") && facets.isConfiguration()) {
                        path = "/rhq/resource/configuration/view.xhtml";
                    } else if (!path.startsWith("/rhq/resource/content/view.xhtml") && path.startsWith("/rhq/resource/content/") && facets.isContent()) {
                        path = "/rhq/resource/content/view.xhtml";
                    } else if (!(!path.startsWith("/rhq/resource/inventory/") || path.startsWith("/rhq/resource/inventory/view.xhtml") || facets.isPluginConfiguration() && path.startsWith("/rhq/resource/inventory/view-connection.xhtml") || path.startsWith("/rhq/resource/inventory/view-agent.xhtml"))) {
                        path = "/rhq/resource/inventory/view.xhtml";
                    } else if (path.startsWith("/rhq/resource/operation/resourceOperationHistoryDetails.xhtml")) {
                        path = "/rhq/resource/operation/resourceOperationHistory.xhtml";
                    } else if (path.startsWith("/rhq/resource/operation/resourceOperationScheduleDetails.xhtml")) {
                        path = "/rhq/resource/operation/resourceOperationSchedules.xhtml";
                    } else if (path.startsWith("/rhq/resource/monitor/response.xhtml") && !facets.isCallTime()) {
                        path = fallbackPath;
                    }
                    response.sendRedirect(path + "?id=" + ((Resource)node.getData()).getId());
                } else if (node.getData() instanceof AutoGroupComposite) {
                    AutoGroupComposite ag = (AutoGroupComposite)node.getData();
                    if (ag.getSubcategory() != null) {
                        state.setSelected(e.getOldSelection());
                        FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "No subcategory pages exist", null));
                        return;
                    }
                    if (ag.getMemberCount() != (long)node.getChildren().size()) {
                        state.setSelected(e.getOldSelection());
                        FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "You must have view access to all resources in an autogroup to view it", null));
                        return;
                    }
                    String path = "/rhq/autogroup/monitor/graphs.xhtml?parent=" + ag.getParentResource().getId() + "&type=" + ag.getResourceType().getId();
                    response.sendRedirect(path);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public Boolean adviseNodeOpened(UITree tree) {
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        if (key != null) {
            Object data;
            ResourceTreeNode treeNode = (ResourceTreeNode)tree.getRowData((Object)key);
            TreeState state = (TreeState)tree.getComponentState();
            TreeRowKey selectedKey = state.getSelectedNode();
            if (selectedKey == null) {
                selectedKey = this.selectedKey;
            }
            if (selectedKey == null) {
                String typeId = FacesContextUtility.getOptionalRequestParameter((String)"type");
                int n = this.selecteAGTypeId = typeId == null || typeId.length() == 0 ? 0 : Integer.parseInt(typeId);
                if (typeId != null) {
                    String id = FacesContextUtility.getOptionalRequestParameter((String)"parent");
                    if (id != null && id.length() != 0) {
                        this.selectedId = Integer.parseInt(id);
                    }
                } else {
                    String id = FacesContextUtility.getOptionalRequestParameter((String)"id");
                    if (id != null && id.length() != 0) {
                        this.selectedId = Integer.parseInt(id);
                    }
                }
                if (this.preopen((ResourceTreeNode)tree.getRowData((Object)key), this.selectedId, this.selecteAGTypeId)) {
                    return true;
                }
            }
            if (selectedKey != null && key.isSubKey(selectedKey)) {
                return Boolean.TRUE;
            }
            if (this.altered ? state.isExpanded(key) : (data = ((ResourceTreeNode)tree.getRowData((Object)key)).getData()) instanceof Resource && ((Resource)data).getResourceType().getCategory() == ResourceCategory.PLATFORM) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    private boolean preopen(ResourceTreeNode resourceTreeNode, int selectedResourceId, int selectedAGTypeId) {
        AutoGroupComposite ag;
        if (resourceTreeNode.getData() instanceof Resource && selectedAGTypeId == 0 ? ((Resource)resourceTreeNode.getData()).getId() == selectedResourceId : resourceTreeNode.getData() instanceof AutoGroupComposite && (ag = (AutoGroupComposite)resourceTreeNode.getData()).getParentResource().getId() == selectedResourceId && ag.getResourceType() != null && ag.getResourceType().getId() == selectedAGTypeId) {
            return true;
        }
        for (ResourceTreeNode child : resourceTreeNode.getChildren()) {
            if (!this.preopen(child, selectedResourceId, selectedAGTypeId)) continue;
            return true;
        }
        return false;
    }

    public Boolean adviseNodeSelected(UITree tree) {
        AutoGroupComposite ag;
        TreeState state = (TreeState)((HtmlTree)tree).getComponentState();
        String id = FacesContextUtility.getOptionalRequestParameter((String)"id");
        String parent = FacesContextUtility.getOptionalRequestParameter((String)"parent");
        String type = FacesContextUtility.getOptionalRequestParameter((String)"type");
        ResourceTreeNode node = (ResourceTreeNode)tree.getRowData(tree.getRowKey());
        if (this.selecteAGTypeId > 0 && node.getData() instanceof AutoGroupComposite && (ag = (AutoGroupComposite)node.getData()).getParentResource() != null && ag.getResourceType() != null && String.valueOf(ag.getParentResource().getId()).equals(parent) && String.valueOf(ag.getResourceType().getId()).equals(type)) {
            return true;
        }
        if (node.getData() instanceof Resource && String.valueOf(((Resource)node.getData()).getId()).equals(id)) {
            return Boolean.TRUE;
        }
        if (tree.getRowKey().equals(state.getSelectedNode())) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean getHasMessages() {
        this.hasMessages = FacesContext.getCurrentInstance().getMessages("leftNavTreeForm:leftNavTree").hasNext();
        return this.hasMessages;
    }
}

