/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.subsystem;

import java.util.Date;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.composite.AlertHistoryComposite;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.subsystem.SubsystemAlertHistoryUIBean;
import org.rhq.enterprise.gui.subsystem.SubsystemView;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.subsystem.AlertSubsystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SubsystemAlertHistoryUIBean
extends SubsystemView {
    public static final String MANAGED_BEAN_NAME = "SubsystemAlertHistoryUIBean";
    private static final String FORM_PREFIX = "alertHistorySubsystemForm:";
    private final String CALENDAR_SUFFIX = "InputDate";
    private AlertSubsystemManagerLocal manager = LookupUtil.getAlertSubsystemManager();
    private static String datePattern;
    private String resourceFilter;
    private String parentFilter;
    private Date dateBeginFilter;
    private Date dateEndFilter;
    private String categoryFilter;
    private SelectItem[] categoryFilterItems;
    private static final IntExtractor<AlertHistoryComposite> RESOURCE_ID_EXTRACTOR;

    public SubsystemAlertHistoryUIBean() {
        datePattern = EnterpriseFacesContextUtility.getWebUser().getWebPreferences().getDateTimeDisplayPreferences().getDateTimeFormatTrigger();
        this.categoryFilterItems = SelectItemUtils.convertFromEnum(AlertConditionCategory.class, (boolean)true);
        this.categoryFilter = (String)this.categoryFilterItems[0].getValue();
    }

    public String getDatePattern() {
        return datePattern;
    }

    public String getResourceFilter() {
        return this.resourceFilter;
    }

    public void setResourceFilter(String resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public String getParentFilter() {
        return this.parentFilter;
    }

    public void setParentFilter(String parentFilter) {
        this.parentFilter = parentFilter;
    }

    public Date getDateBeginFilter() {
        return this.dateBeginFilter;
    }

    public void setDateBeginFilter(Date dateSubmittedFilter) {
        this.dateBeginFilter = dateSubmittedFilter;
    }

    public Date getDateEndFilter() {
        return this.dateEndFilter;
    }

    public void setDateEndFilter(Date dateCompletedFilter) {
        this.dateEndFilter = dateCompletedFilter;
    }

    public String getCategoryFilter() {
        return this.categoryFilter;
    }

    public void setCategoryFilter(String statusFilter) {
        this.categoryFilter = statusFilter;
    }

    public SelectItem[] getCategoryFilterItems() {
        return this.categoryFilterItems;
    }

    public void setCategoryFilterItems(SelectItem[] statusFilterItems) {
        this.categoryFilterItems = statusFilterItems;
    }

    public String deleteSelected() {
        Integer[] selected = this.getSelectedItems();
        try {
            int numDeleted = this.manager.deleteAlertHistories(this.getSubject(), selected);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + numDeleted + " alerts."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected alerts.", (Throwable)e);
        }
        return "success";
    }

    public String purge() {
        try {
            int numDeleted = this.manager.purgeAllAlertHistories(this.getSubject());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + numDeleted + " alerts."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected alerts.", (Throwable)e);
        }
        return "success";
    }

    public String acknowledgeSelectedAlerts() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        try {
            Integer[] selectedItems = this.getSelectedItems();
            int num = alertManager.acknowledgeAlerts(subject, resource.getId(), selectedItems);
            if (num == -1) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"No Alerts passed to ack");
            } else {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Acknowledged " + num + " alerts"));
            }
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to acknowledge selected alerts.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ResultsDataModel(this, PageControlView.SubsystemAlertHistory, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    static /* synthetic */ AlertSubsystemManagerLocal access$000(SubsystemAlertHistoryUIBean x0) {
        return x0.manager;
    }

    static /* synthetic */ IntExtractor access$100() {
        return RESOURCE_ID_EXTRACTOR;
    }

    static /* synthetic */ String access$202(SubsystemAlertHistoryUIBean x0, String x1) {
        x0.resourceFilter = x1;
        return x0.resourceFilter;
    }

    static /* synthetic */ String access$302(SubsystemAlertHistoryUIBean x0, String x1) {
        x0.parentFilter = x1;
        return x0.parentFilter;
    }

    static /* synthetic */ Date access$402(SubsystemAlertHistoryUIBean x0, Date x1) {
        x0.dateBeginFilter = x1;
        return x0.dateBeginFilter;
    }

    static /* synthetic */ Date access$502(SubsystemAlertHistoryUIBean x0, Date x1) {
        x0.dateEndFilter = x1;
        return x0.dateEndFilter;
    }

    static /* synthetic */ String access$602(SubsystemAlertHistoryUIBean x0, String x1) {
        x0.categoryFilter = x1;
        return x0.categoryFilter;
    }

    static /* synthetic */ String access$700() {
        return datePattern;
    }

    static {
        RESOURCE_ID_EXTRACTOR = new /* Unavailable Anonymous Inner Class!! */;
    }
}

