/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.util;

import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.legacy.DefaultConstants;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.MetricsDisplayMode;
import org.rhq.enterprise.server.common.EntityContext;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class WebUtility {
    private static final Log LOG = LogFactory.getLog((String)WebUtility.class.getName());

    public static Integer getResourceId(ServletRequest request) {
        String resourceIdString = request.getParameter("currentResourceId");
        if (resourceIdString == null || resourceIdString.equals("")) {
            resourceIdString = request.getParameter("id");
        }
        Integer resourceId = null;
        if (resourceIdString != null && !resourceIdString.equals("")) {
            resourceId = Integer.parseInt(resourceIdString);
        }
        return resourceId;
    }

    public static Integer getResourceGroupId(ServletRequest request) {
        String groupIdString = request.getParameter("groupId");
        Integer groupId = null;
        if (groupIdString != null && !groupIdString.equals("")) {
            groupId = Integer.parseInt(groupIdString);
        }
        return groupId;
    }

    public static int[] getResourceIds(ServletRequest request) {
        int[] ids;
        String[] resourceIdStrings = request.getParameterValues("id");
        if (resourceIdStrings == null) {
            ids = new int[]{};
        } else {
            ids = new int[resourceIdStrings.length];
            for (int i = 0; i < resourceIdStrings.length; ++i) {
                ids[i] = Integer.parseInt(resourceIdStrings[i]);
            }
        }
        return ids;
    }

    public static PageControl getPageControl(ServletRequest request) {
        return WebUtility.getPageControl((ServletRequest)request, null);
    }

    public static PageControl getPageControl(ServletRequest request, String postfix) {
        String sortColumn;
        if (postfix == null) {
            postfix = "";
        }
        int pageNumber = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)("pn" + postfix), (int)DefaultConstants.PAGENUM_DEFAULT);
        int pageSize = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)("ps" + postfix), (int)DefaultConstants.PAGESIZE_DEFAULT);
        pageSize = Math.min(pageSize, 100);
        String sortOrderString = request.getParameter("so" + postfix);
        PageOrdering sortOrder = PageOrdering.ASC;
        if (sortOrderString != null && sortOrderString.length() > 0) {
            try {
                sortOrder = PageOrdering.valueOf((String)sortOrderString.toUpperCase());
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Request parameter 'so" + postfix + "' has an invalid value ('" + sortOrderString + "') - valid values are 'asc' or 'desc' (case-insensitive).");
            }
        }
        if ((sortColumn = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)("sc" + postfix), null)) != null && sortColumn.contains(" ") && !sortColumn.toLowerCase().endsWith(" desc")) {
            throw new RuntimeException("This app is not vulnerable to SQL-injection attacks. Thanks for playing.");
        }
        return new PageControl(pageNumber, pageSize, new OrderingField[]{new OrderingField(sortColumn, sortOrder)});
    }

    public static int getResourceTypeId(HttpServletRequest request) throws ParameterNotFoundException {
        return WebUtility.getRequiredIntRequestParameter((ServletRequest)request, (String)"type");
    }

    public static int getChildResourceTypeId(HttpServletRequest request) throws ParameterNotFoundException {
        return WebUtility.getRequiredIntRequestParameter((ServletRequest)request, (String)"ctype");
    }

    public static String getRequiredRequestParameter(ServletRequest request, String name) {
        WebUtility.logWarningIfParameterHasMultipleValues((ServletRequest)request, (String)name);
        String value = request.getParameter(name);
        if (value == null) {
            throw new ParameterNotFoundException("Required request parameter '" + name + "' does not exist.");
        }
        return value;
    }

    public static String getOptionalRequestParameter(ServletRequest request, String name, String defaultValue) {
        WebUtility.logWarningIfParameterHasMultipleValues((ServletRequest)request, (String)name);
        String value = request.getParameter(name);
        return value == null ? defaultValue : value;
    }

    public static int getRequiredIntRequestParameter(ServletRequest request, String name) {
        int intValue;
        String value = WebUtility.getRequiredRequestParameter((ServletRequest)request, (String)name);
        if (value.length() == 0) {
            throw new ParameterNotFoundException("Required request parameter '" + name + "' has an empty value.");
        }
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ParameterNotFoundException("Request parameter '" + name + "' has value '" + value + "', which is not a valid integer.");
        }
        return intValue;
    }

    public static int getOptionalIntRequestParameter(ServletRequest request, String name, int defaultValue) {
        String value = request.getParameter(name);
        return value != null && value.length() > 0 ? Integer.parseInt(value) : defaultValue;
    }

    private static void logWarningIfParameterHasMultipleValues(ServletRequest request, String name) {
        if (request.getParameterValues(name) != null && request.getParameterValues(name).length > 1) {
            LOG.warn((Object)("More than one '" + name + "' request parameter exists - exactly one is required (values are " + Arrays.asList(request.getParameterValues(name)) + ")."));
        }
    }

    public static Subject getSubject(HttpServletRequest request) {
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        Subject subject = user.getSubject();
        return subject;
    }

    public static MetricsDisplayMode getMetricsDisplayMode(HttpServletRequest request) {
        MetricsDisplayMode mode;
        int resourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"id", (int)-1);
        int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        int resourceTypeId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        if (groupId > 0) {
            mode = MetricsDisplayMode.COMPGROUP;
        } else if (resourceTypeId > 0 && parent == -1) {
            mode = MetricsDisplayMode.RESOURCE_DEFAULT;
        } else if (resourceId > 0) {
            mode = MetricsDisplayMode.RESOURCE;
        } else if (resourceTypeId > 0 && parent > 0) {
            mode = MetricsDisplayMode.AUTOGROUP;
        } else {
            mode = MetricsDisplayMode.UNSET;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Unknown input parameter combination - we can't go on");
            }
        }
        return mode;
    }

    public static EntityContext getEntityContext() {
        HttpServletRequest request = FacesContextUtility.getRequest();
        return WebUtility.getEntityContext((HttpServletRequest)request);
    }

    public static EntityContext getEntityContext(HttpServletRequest request) {
        int resourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"id", (int)-1);
        int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        int parentResourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        int resourceTypeId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        return new EntityContext(Integer.valueOf(resourceId), Integer.valueOf(groupId), Integer.valueOf(parentResourceId), Integer.valueOf(resourceTypeId));
    }
}

