/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.action.license;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.enterprise.gui.action.license.LicenseForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.ContextUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.license.CorruptLicenseException;
import org.rhq.enterprise.server.license.LicenseManager;
import org.rhq.enterprise.server.license.UnavailableLicenseException;
import org.rhq.enterprise.server.license.UpdateTrialLicenseException;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class LicenseUpdateAction
extends BaseAction {
    static Log log = LogFactory.getLog((String)LicenseUpdateAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LicenseForm licenseForm = (LicenseForm)form;
        if (licenseForm.isCancelClicked()) {
            return this.returnCancelled(request, mapping);
        }
        if (licenseForm.isResetClicked()) {
            return this.returnReset(request, mapping);
        }
        if (licenseForm.isOkClicked()) {
            Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
            AuthorizationManagerLocal authzManager = LookupUtil.getAuthorizationManager();
            if (!authzManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS)) {
                log.error((Object)"License file can only be updated by users who have permission to manage server settings");
                return this.returnFailure(request, mapping);
            }
            if (licenseForm.licenseFile.getFileData() == null || licenseForm.licenseFile.getFileData().length == 0) {
                return this.returnFailure(request, mapping);
            }
            log.debug((Object)"Updating license with uploaded file.");
            ByteArrayInputStream is = new ByteArrayInputStream(licenseForm.licenseFile.getFileData());
            try {
                LicenseManager.checkLicense((InputStream)is);
            }
            catch (CorruptLicenseException cle) {
                log.error((Object)"License file is corrupt or not in sync with previous records");
                return this.returnFailure(request, mapping);
            }
            catch (UpdateTrialLicenseException tlue) {
                log.error((Object)"Licenses can not be updated by trial licenses");
                return this.returnFailure(request, mapping);
            }
            catch (UnavailableLicenseException ule) {
                log.error((Object)"Backing store unavailable, allowing license to be written to disk unconditionally");
            }
            catch (Exception e) {
                log.error((Object)"Unable to update license file", (Throwable)e);
                return this.returnFailure(request, mapping);
            }
            log.debug((Object)"Uploaded license file validated");
            SystemManagerLocal systemManager = LookupUtil.getSystemManager();
            systemManager.updateLicense(subject, licenseForm.licenseFile.getFileData());
            RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.license.confirm.LicenseUpdated");
            ContextUtils.updateMonitoringEnabled((ServletContext)this.getServlet().getServletContext());
        }
        return this.returnSuccess(request, mapping);
    }
}

