/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.group;

import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.faces.Redirect;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.configuration.group.AbstractGroupResourceConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateStillInProgressException;

@Name(value="EditGroupResourceConfigurationUIBean")
@Scope(value=ScopeType.CONVERSATION)
public class EditGroupResourceConfigurationUIBean
extends AbstractGroupResourceConfigurationUIBean {
    public static final String VIEW_ID = "/rhq/group/configuration/editCurrent.xhtml";
    @In(value="org.jboss.seam.faces.redirect")
    private Redirect redirect;

    @Create
    @Begin
    public void init() {
        this.loadConfigurations();
        this.redirect.setParameter("groupId", (Object)this.getGroup().getId());
    }

    public void updateConfigurations() {
        String viewId = null;
        try {
            this.getConfigurationSet().applyGroupConfiguration();
            this.getConfigurationManager().scheduleGroupResourceConfigurationUpdate(EnterpriseFacesContextUtility.getSubject(), this.getGroup().getId(), this.getResourceConfigurations());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Group Resource Configuration update scheduled.");
            Conversation.instance().endBeforeRedirect();
            viewId = "/rhq/group/configuration/history.xhtml";
        }
        catch (ConfigurationUpdateStillInProgressException updateException) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"Configuration update is currently in progress. Please consider reviewing the changes before submitting.");
            viewId = VIEW_ID;
        }
        catch (PermissionException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getLocalizedMessage());
            viewId = "/rhq/group/configuration/viewCurrent.xhtml";
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to schedule group Resource Configuration update - cause: " + e));
            viewId = VIEW_ID;
        }
        this.redirect.setViewId(viewId);
        this.redirect.execute();
    }

    @End
    public void cancel() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Edit canceled.");
        this.redirect.setViewId("/rhq/group/configuration/viewCurrent.xhtml");
        this.redirect.execute();
    }

    @End
    public void reset() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"All properties reset to original values.");
        this.redirect.setViewId(VIEW_ID);
        this.redirect.execute();
    }
}

