/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.definition.group;

import javax.faces.application.FacesMessage;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.GroupDefinition;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.definition.group.GroupDefinitionUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionException;
import org.rhq.enterprise.server.resource.group.definition.framework.InvalidExpressionException;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditGroupDefinitionGeneralPropertiesUIBean {
    private final Log log = LogFactory.getLog(EditGroupDefinitionGeneralPropertiesUIBean.class);
    public static final String MANAGED_BEAN_NAME = "EditGroupDefinitionGeneralPropertiesUIBean";
    private static final String OUTCOME_SUCCESS = "success";
    private static final String OUTCOME_FAILURE = "failure";
    private static final String TEMPORARY_EDIT_MARKER = "temporaryEditGroupDef-Marker";
    private static final String TEMPORARY_EXPRESSION_ATTRIBUTE = "temporaryGroupDefExpr";
    private static final String TEMPORARY_NAME_ATTRIBUTE = "temporaryGroupDefName";
    private static final String TEMPORARY_DESCRIPTION_ATTRIBUTE = "temporaryGroupDefDescription";
    private static final String TEMPORARY_RECURSIVE_ATTRIBUTE = "temporaryGroupDefRecursive";
    private static final String TEMPORARY_RECALCULATION_INTERVAL = "recalculationInterval";
    private String name;
    private String description;
    private boolean recursive;
    private int recalculationInterval;
    private String expression;
    private GroupDefinitionManagerLocal groupDefinitionManager = LookupUtil.getGroupDefinitionManager();

    public EditGroupDefinitionGeneralPropertiesUIBean() {
        GroupDefinition groupDefinition = null;
        try {
            groupDefinition = GroupDefinitionUIBean.lookupGroupDefinition();
        }
        catch (GroupDefinitionException gde) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Problem looking up group definition: " + gde.getMessage()));
            return;
        }
        HttpSession session = FacesContextUtility.getRequest().getSession();
        String marker = (String)session.getAttribute(TEMPORARY_EDIT_MARKER);
        String previousExpression = (String)session.getAttribute(TEMPORARY_EXPRESSION_ATTRIBUTE);
        String previousName = (String)session.getAttribute(TEMPORARY_NAME_ATTRIBUTE);
        String previousDescription = (String)session.getAttribute(TEMPORARY_DESCRIPTION_ATTRIBUTE);
        String previousRecursive = (String)session.getAttribute(TEMPORARY_RECURSIVE_ATTRIBUTE);
        String previousInterval = (String)session.getAttribute(TEMPORARY_RECALCULATION_INTERVAL);
        if (marker == null) {
            this.expression = groupDefinition.getExpression();
            this.name = groupDefinition.getName();
            this.description = groupDefinition.getDescription();
            this.recursive = groupDefinition.isRecursive();
            this.recalculationInterval = (int)(groupDefinition.getRecalculationInterval() / 60000L);
        } else {
            this.expression = previousExpression;
            this.name = previousName;
            this.description = previousDescription;
            this.recursive = previousRecursive.equals("TRUE");
            this.recalculationInterval = previousInterval == null ? 0 : Integer.parseInt(previousInterval);
        }
        session.removeAttribute(TEMPORARY_EDIT_MARKER);
        session.removeAttribute(TEMPORARY_EXPRESSION_ATTRIBUTE);
        session.removeAttribute(TEMPORARY_NAME_ATTRIBUTE);
        session.removeAttribute(TEMPORARY_DESCRIPTION_ATTRIBUTE);
        session.removeAttribute(TEMPORARY_RECURSIVE_ATTRIBUTE);
        session.removeAttribute(TEMPORARY_RECALCULATION_INTERVAL);
    }

    public String begin() {
        return OUTCOME_SUCCESS;
    }

    public String update() {
        try {
            GroupDefinition groupDefinition = GroupDefinitionUIBean.lookupGroupDefinition();
            groupDefinition.setName(this.name);
            groupDefinition.setDescription(this.description);
            groupDefinition.setRecursive(this.recursive);
            groupDefinition.setRecalculationInterval(Long.valueOf((long)this.recalculationInterval * 60000L));
            groupDefinition.setExpression(this.expression.replaceAll("\\r", "\n").replaceAll("\\f", "\n").replaceAll("\\n+", "\n"));
            HttpSession session = FacesContextUtility.getRequest().getSession();
            session.setAttribute(TEMPORARY_EDIT_MARKER, (Object)"marker");
            session.setAttribute(TEMPORARY_EXPRESSION_ATTRIBUTE, (Object)this.expression);
            session.setAttribute(TEMPORARY_NAME_ATTRIBUTE, (Object)this.name);
            session.setAttribute(TEMPORARY_DESCRIPTION_ATTRIBUTE, (Object)this.description);
            session.setAttribute(TEMPORARY_RECURSIVE_ATTRIBUTE, (Object)(this.recursive ? "TRUE" : "FALSE"));
            session.setAttribute(TEMPORARY_RECALCULATION_INTERVAL, (Object)String.valueOf(this.recalculationInterval));
            this.groupDefinitionManager.updateGroupDefinition(EnterpriseFacesContextUtility.getSubject(), groupDefinition);
        }
        catch (GroupDefinitionException gde) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Problem updating group definition: " + gde.getMessage()));
            return OUTCOME_FAILURE;
        }
        catch (InvalidExpressionException iee) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Syntax error in your group definition: " + iee.getMessage()));
            return OUTCOME_FAILURE;
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error updating group definition: " + e.getMessage()));
            this.log.error((Object)"Error updating group definition: ", (Throwable)e);
            return OUTCOME_FAILURE;
        }
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"General properties updated.");
        return OUTCOME_SUCCESS;
    }

    public String reset() {
        return OUTCOME_FAILURE;
    }

    public String createGroups() {
        try {
            GroupDefinition groupDefinition = GroupDefinitionUIBean.lookupGroupDefinition();
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            this.groupDefinitionManager.calculateGroupMembership(subject, groupDefinition.getId());
        }
        catch (GroupDefinitionException gde) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Problem updating group definition: " + gde.getMessage()));
            this.log.error((Object)"Problem updating group definition: ", (Throwable)gde);
            return OUTCOME_FAILURE;
        }
        catch (InvalidExpressionException iee) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Syntax error in one of your group definition expressions: " + iee.getMessage()));
            this.log.error((Object)"Syntax error in one of your group definition expressions: ", (Throwable)iee);
            return OUTCOME_FAILURE;
        }
        catch (ResourceGroupUpdateException rgue) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("There was a problem adding one or more resource groups: " + rgue.getMessage()));
            this.log.error((Object)"There was a problem adding one or more resource groups: ", (Throwable)rgue);
            return OUTCOME_FAILURE;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof ClassCastException) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"Probable syntax error: this is likely due to comparing an integer property of resource (such as id) to a non-numeric, or using a string function (startswith, endswith, or contains) on an integer property");
                this.log.error((Object)"There was a problem calculating the results: ", t);
                return OUTCOME_FAILURE;
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("There was a problem calculating the results: " + e.getMessage()));
            this.log.error((Object)"There was a problem calculating the results: ", (Throwable)e);
            return OUTCOME_FAILURE;
        }
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Group Definition's Resource Groups Calculated.");
        return OUTCOME_SUCCESS;
    }

    public String cancel() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"General properties not updated.");
        return OUTCOME_SUCCESS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getRecalculationInterval() {
        return this.recalculationInterval;
    }

    public void setRecalculationInterval(int recalculationInterval) {
        this.recalculationInterval = recalculationInterval;
    }
}

