/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.group;

import java.io.IOException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.flyweight.AutoGroupCompositeFlyweight;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.group.ResourceGroupTreeNode;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.cluster.ClusterKey;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.UITree;
import org.richfaces.component.html.HtmlTree;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.event.NodeExpandedEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeRowKey;

public class ResourceGroupTreeStateAdvisor
implements TreeStateAdvisor {
    private Integer selectedId;
    private ClusterKey selectedClusterKey;
    private TreeState treeState = new TreeState();
    private ResourceGroup currentGroup;

    public TreeState getTreeState() {
        return this.treeState;
    }

    private ResourceGroup getCurrentGroup() {
        if (this.currentGroup == null || this.currentGroup.getId() != this.getSelectedGroupId()) {
            this.selectedId = this.getSelectedGroupId();
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            this.currentGroup = groupManager.getResourceGroupById(EnterpriseFacesContextUtility.getSubject(), this.selectedId.intValue(), null);
            if (!this.currentGroup.isVisible()) {
                this.selectedClusterKey = ClusterKey.valueOf((String)this.currentGroup.getClusterKey());
            }
        }
        return this.currentGroup;
    }

    private int getSelectedGroupId() {
        String groupId = FacesContextUtility.getOptionalRequestParameter((String)"groupId");
        return Integer.parseInt(groupId);
    }

    public void changeExpandListener(NodeExpandedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        if (state.getSelectedNode() != null) {
            boolean closingParent = false;
            TreeRowKey key = (TreeRowKey)tree.getRowKey();
            ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData((Object)key);
            ResourceGroupTreeNode selectedNode = (ResourceGroupTreeNode)tree.getRowData((Object)state.getSelectedNode());
            for (selectedNode = selectedNode.getParent(); selectedNode != null; selectedNode = selectedNode.getParent()) {
                if (!node.equals(selectedNode)) continue;
                closingParent = true;
                break;
            }
            if (closingParent) {
                state.setSelected(key);
                this.redirectTo(node);
            }
        }
    }

    public Boolean adviseNodeOpened(UITree tree) {
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        if (key != null) {
            ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData((Object)key);
            if (node.getParent() == null) {
                return true;
            }
            TreeState state = (TreeState)tree.getComponentState();
            TreeRowKey selectedKey = state.getSelectedNode();
            if (selectedKey == null) {
                this.getCurrentGroup();
                if (this.preopen((ResourceGroupTreeNode)tree.getRowData((Object)key), this.selectedClusterKey)) {
                    return true;
                }
            }
            return state.isExpanded(key);
        }
        return null;
    }

    private boolean preopen(ResourceGroupTreeNode resourceTreeNode, ClusterKey selectedClusterKey) {
        ResourceGroup currentGroup = this.getCurrentGroup();
        if (resourceTreeNode.getData() instanceof ClusterKey) {
            if (((ClusterKey)resourceTreeNode.getData()).equals((Object)selectedClusterKey)) {
                return true;
            }
        } else if (resourceTreeNode.getData() instanceof AutoGroupCompositeFlyweight) {
            ClusterKey key = resourceTreeNode.getClusterKey();
            AutoGroupCompositeFlyweight ag = (AutoGroupCompositeFlyweight)resourceTreeNode.getData();
            if (key.equals((Object)selectedClusterKey)) {
                return true;
            }
        } else if (resourceTreeNode.getData() instanceof ResourceGroup && currentGroup.getId() == ((ResourceGroup)resourceTreeNode.getData()).getId()) {
            return true;
        }
        for (ResourceGroupTreeNode child : resourceTreeNode.getChildren()) {
            if (!this.preopen(child, selectedClusterKey)) continue;
            return true;
        }
        return false;
    }

    public void nodeSelectListener(NodeSelectedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData((Object)key);
        if (node != null && !this.redirectTo(node)) {
            state.setSelected(e.getOldSelection());
        }
    }

    public Boolean adviseNodeSelected(UITree tree) {
        ResourceGroup currentGroup = this.getCurrentGroup();
        ResourceGroupTreeNode node = (ResourceGroupTreeNode)tree.getRowData(tree.getRowKey());
        if (node.getData() instanceof ResourceGroup) {
            return this.selectedId.intValue() == ((ResourceGroup)node.getData()).getId();
        }
        if (node.getData() instanceof ClusterKey) {
            ClusterKey key = (ClusterKey)node.getData();
            if (currentGroup.getClusterKey() != null && currentGroup.getClusterKey().equals(key.getKey())) {
                return true;
            }
        }
        return false;
    }

    private boolean redirectTo(ResourceGroupTreeNode node) {
        HttpServletResponse response = (HttpServletResponse)FacesContextUtility.getFacesContext().getExternalContext().getResponse();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String path = "";
        if (node.getData() instanceof ClusterKey) {
            ClusterManagerLocal clusterManager = LookupUtil.getClusterManager();
            ResourceGroup group = clusterManager.createAutoClusterBackingGroup(subject, (ClusterKey)node.getData(), true);
            path = "/rhq/group/inventory/view.xhtml";
            path = path + "?groupId=" + group.getId() + "&parentGroupId=" + ((ClusterKey)node.getData()).getClusterGroupId();
        } else {
            if (node.getData() instanceof AutoGroupCompositeFlyweight) {
                FacesContext.getCurrentInstance().addMessage("leftNavGroupTreeForm:leftNavGroupTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "No cluster autogroup views available", null));
                return false;
            }
            if (node.getData() instanceof ResourceGroup) {
                path = "/rhq/group/inventory/view.xhtml";
                path = path + "?groupId=" + ((ResourceGroup)node.getData()).getId();
            }
        }
        try {
            response.sendRedirect(path);
            return true;
        }
        catch (IOException ioe) {
            FacesContext.getCurrentInstance().addMessage("leftNavGroupTreeForm:leftNavGroupTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "Unable to browse to selected group view: " + ioe.getMessage(), null));
            return false;
        }
    }
}

