/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.alert.ListAlertHistoryUIBean;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListAlertHistoryUIBean
extends PagedDataTableUIBean {
    private static final Log log = LogFactory.getLog(ListAlertHistoryUIBean.class);
    public static final String MANAGED_BEAN_NAME = "ListAlertHistoryUIBean";
    private String dateFilter;
    private String dateErrors;
    private String alertDefinitionFilter;
    private String alertPriorityFilter;
    private SelectItem[] alertDefinitionSelectItems;
    private SelectItem[] alertPrioritySelectItems;
    private AlertManagerLocal alertManager = LookupUtil.getAlertManager();
    private AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();

    public String getDateFilter() {
        if (this.dateFilter == null) {
            this.dateFilter = FacesContextUtility.getOptionalRequestParameter((String)"alertHistoryForm:dateFilter");
        }
        return this.dateFilter;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public String getDateErrors() {
        return this.dateErrors;
    }

    public void setDateErrors(String dateErrors) {
        this.dateErrors = dateErrors;
    }

    public String getAlertDefinitionFilter() {
        if (this.alertDefinitionFilter == null) {
            this.alertDefinitionFilter = SelectItemUtils.getSelectItemFilter((String)"alertHistoryForm:alertDefinitionFilter");
        }
        return SelectItemUtils.cleanse((String)this.alertDefinitionFilter);
    }

    public void setAlertDefinitionFilter(String alertDefinitionFilter) {
        this.alertDefinitionFilter = alertDefinitionFilter;
    }

    public SelectItem[] getAlertDefinitionSelectItems() {
        if (this.alertDefinitionSelectItems == null) {
            List optionItems = this.alertDefinitionManager.findAlertDefinitionOptionItemsForResource(this.getSubject(), this.getResource().getId());
            this.alertDefinitionSelectItems = SelectItemUtils.convertFromListOptionItem((List)optionItems, (boolean)true);
        }
        return this.alertDefinitionSelectItems;
    }

    public void setAlertDefinitionSelectItems(SelectItem[] alertDefinitionSelectItems) {
        this.alertDefinitionSelectItems = alertDefinitionSelectItems;
    }

    public String getAlertPriorityFilter() {
        if (this.alertPriorityFilter == null) {
            this.alertPriorityFilter = SelectItemUtils.getSelectItemFilter((String)"alertHistoryForm:alertPriorityFilter");
        }
        return SelectItemUtils.cleanse((String)this.alertPriorityFilter);
    }

    public void setAlertPriorityFilter(String alertPriorityFilter) {
        this.alertPriorityFilter = alertPriorityFilter;
    }

    public SelectItem[] getAlertPrioritySelectItems() {
        if (this.alertPrioritySelectItems == null) {
            this.alertPrioritySelectItems = SelectItemUtils.convertFromEnum(AlertPriority.class, (boolean)true);
        }
        return this.alertPrioritySelectItems;
    }

    public void setAlertPrioritySelectItems(SelectItem[] alertPrioritySelectItems) {
        this.alertPrioritySelectItems = alertPrioritySelectItems;
    }

    public String deleteSelectedAlerts() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        String[] selectedAlerts = this.getSelectedAlerts();
        Integer[] alertDefinitionIds = StringUtility.getIntegerArray((String[])selectedAlerts);
        try {
            this.alertManager.deleteAlerts(subject, resource.getId(), alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + alertDefinitionIds.length + " alerts."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected alerts.", (Throwable)e);
        }
        return "success";
    }

    public String acknowledgeSelectedAlerts() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        String[] selectedAlerts = this.getSelectedAlerts();
        Integer[] alertIds = StringUtility.getIntegerArray((String[])selectedAlerts);
        try {
            int num = this.alertManager.acknowledgeAlerts(subject, alertIds);
            if (num == -1) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"No Alerts passed to ack");
            } else {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Acknowledged " + num + " alerts"));
            }
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to acknowledge selected alerts.", (Throwable)e);
        }
        return "success";
    }

    public String purgeAllAlerts() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        try {
            int numDeleted = this.alertManager.deleteAlerts(subject, resource.getId());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + numDeleted + " alerts on this resource"));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to delete alerts for resource[ " + resource.getId() + " ]"), (Throwable)e);
            log.error((Object)("failed to delete alerts for resource[ " + resource.getId() + " ]"), (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListAlertDefinitionsDataModel(this, PageControlView.AlertHistoryList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private Integer getAlertDefinitionId() {
        String alertDefinitionString = this.getAlertDefinitionFilter();
        if (alertDefinitionString != null) {
            return Integer.parseInt(alertDefinitionString);
        }
        return null;
    }

    private AlertPriority getAlertPriority() {
        String alertPriorityName = this.getAlertPriorityFilter();
        if (alertPriorityName != null) {
            return Enum.valueOf(AlertPriority.class, alertPriorityName);
        }
        return null;
    }

    private String[] getSelectedAlerts() {
        return FacesContextUtility.getRequest().getParameterValues("selectedAlerts");
    }

    static /* synthetic */ Integer access$000(ListAlertHistoryUIBean x0) {
        return x0.getAlertDefinitionId();
    }

    static /* synthetic */ AlertPriority access$100(ListAlertHistoryUIBean x0) {
        return x0.getAlertPriority();
    }

    static /* synthetic */ AlertManagerLocal access$200(ListAlertHistoryUIBean x0) {
        return x0.alertManager;
    }
}

