/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert.common;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.alert.converter.AlertNotificationConverter;
import org.rhq.enterprise.gui.common.framework.EnterpriseFacesContextUIBean;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.EVENT)
@Name(value="alertNotificationsUIBean")
public class AlertNotificationsUIBean
extends EnterpriseFacesContextUIBean {
    @RequestParameter(value="nid")
    private Integer notificationId;
    @RequestParameter(value="context")
    private String context;
    @RequestParameter(value="contextId")
    private Integer contextId;
    @In
    private AlertNotificationManagerLocal alertNotificationManager;
    private List<AlertNotification> alertNotifications;
    private Set<AlertNotification> selectedNotifications;
    private String selectedNewSender;
    private AlertNotification activeNotification;
    private ConfigurationDefinition activeConfigDefinition;
    private AlertNotificationConverter notificationConverter;
    private Map<String, String> alertSenders;

    public List<AlertNotification> getAlertNotifications() {
        return this.alertNotifications;
    }

    public void setAlertNotifications(List<AlertNotification> alertNotifications) {
        this.alertNotifications = alertNotifications;
    }

    public Set<AlertNotification> getSelectedNotifications() {
        return this.selectedNotifications;
    }

    public void setSelectedNotifications(Set<AlertNotification> selectedNotifications) {
        this.selectedNotifications = selectedNotifications;
    }

    public String getSelectedNewSender() {
        return this.selectedNewSender;
    }

    public void setSelectedNewSender(String selectedNewSender) {
        this.selectedNewSender = selectedNewSender;
    }

    public AlertNotification getActiveNotification() {
        return this.activeNotification;
    }

    public void setActiveNotification(AlertNotification activeNotification) {
        this.activeNotification = activeNotification;
        this.lookupActiveConfigDefinition();
    }

    public ConfigurationDefinition getActiveConfigDefinition() {
        return this.activeConfigDefinition;
    }

    public AlertNotificationConverter getNotificationConverter() {
        return this.notificationConverter;
    }

    public Map<String, String> getAlertSenders() {
        return this.alertSenders;
    }

    private void lookupActiveConfigDefinition() {
        if (this.activeNotification != null) {
            String senderName = this.activeNotification.getSenderName();
            this.activeConfigDefinition = this.alertNotificationManager.getConfigurationDefinitionForSender(senderName);
        }
    }

    @Create
    public void initNotifications() {
        this.reloadAlertNotifications();
        this.selectedNotifications = new HashSet();
        this.notificationConverter = new AlertNotificationConverter();
        this.notificationConverter.setAlertNotifications(this.alertNotifications);
        this.alertSenders = this.lookupAlertSenders();
        this.selectActiveNotification();
    }

    public void reloadAlertNotifications() {
        this.alertNotifications = this.alertNotificationManager.getNotificationsForAlertDefinition(this.getSubject(), this.contextId.intValue());
    }

    private void selectActiveNotification() {
        if (this.notificationId != null) {
            for (AlertNotification notification : this.alertNotifications) {
                if (notification.getId() != this.notificationId.intValue()) continue;
                this.setActiveNotification(notification);
                this.selectedNotifications.add(notification);
                return;
            }
        }
    }

    private Map<String, String> lookupAlertSenders() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String sender : this.alertNotificationManager.listAllAlertSenders()) {
            result.put(sender, sender);
        }
        return result;
    }

    public String addAlertSender() {
        try {
            Configuration newSenderConfig = null;
            ConfigurationDefinition configDefinition = this.alertNotificationManager.getConfigurationDefinitionForSender(this.selectedNewSender);
            newSenderConfig = configDefinition != null ? configDefinition.getDefaultTemplate().createConfiguration() : new Configuration();
            AlertNotification newNotification = new AlertNotification(this.selectedNewSender, newSenderConfig);
            AlertNotification newlyCreated = this.alertNotificationManager.addAlertNotification(this.getSubject(), this.contextId.intValue(), newNotification);
            this.reloadAlertNotifications();
            this.activeNotification = newlyCreated;
            this.selectedNotifications.clear();
            this.selectedNotifications.add(this.activeNotification);
        }
        catch (Throwable t) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to create alert notification", (Throwable)t);
        }
        return "success";
    }

    public String saveConfiguration() {
        try {
            if (this.activeNotification != null) {
                this.alertNotificationManager.updateAlertNotification(this.getSubject(), this.contextId.intValue(), this.activeNotification);
            }
        }
        catch (Throwable t) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to save alert notification", (Throwable)t);
        }
        return "success";
    }

    public String removeSelected() {
        try {
            this.alertNotificationManager.removeNotifications(this.getSubject(), this.contextId, this.getSelectedIds());
            this.alertNotifications.removeAll(this.selectedNotifications);
            this.activeNotification = null;
        }
        catch (Throwable t) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to save remove notifications", (Throwable)t);
        }
        return "success";
    }

    private Integer[] getSelectedIds() {
        Integer[] results = new Integer[this.selectedNotifications.size()];
        int i = 0;
        for (AlertNotification nextNotification : this.selectedNotifications) {
            results[i++] = nextNotification.getId();
        }
        return results;
    }
}

