/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.upload;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.rhq.enterprise.gui.common.upload.MultipartRequestWrapper;

public class MultipartFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean isMultipartContent = ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest);
        if (!isMultipartContent) {
            chain.doFilter(request, response);
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            MultipartRequestWrapper requestWrapper = new MultipartRequestWrapper(httpRequest);
            Map parameterMap = requestWrapper.getParameterMap();
            List items = upload.parseRequest(httpRequest);
            for (FileItem item : items) {
                String itemString = item.getString();
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    parameterMap.put(fieldName, new String[]{itemString});
                    continue;
                }
                httpRequest.setAttribute(fieldName, (Object)item);
            }
            chain.doFilter((ServletRequest)requestWrapper, response);
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

