/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.resourcehealth;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.rhq.core.domain.resource.composite.ResourceHealthComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.portlet.BaseRSSAction;
import org.rhq.enterprise.gui.legacy.portlet.RSSFeed;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RSSAction
extends BaseRSSAction {
    private static final Log log = LogFactory.getLog((String)RSSAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RSSFeed feed = this.getNewRSSFeed(request);
        ResourceManagerLocal manager = LookupUtil.getResourceManager();
        MessageResources res = this.getResources(request);
        feed.setTitle(res.getMessage("dash.home.ResourceHealth"));
        WebUser user = this.getWebUser(request);
        if (user != null) {
            WebUserPreferences preferences = user.getWebPreferences();
            WebUserPreferences.FavoriteResourcePortletPreferences favoriteResourcePreferences = preferences.getFavoriteResourcePortletPreferences();
            PageList results = manager.findResourceHealth(user.getSubject(), favoriteResourcePreferences.asArray(), PageControl.getUnlimitedInstance());
            if (results != null && results.size() > 0) {
                for (ResourceHealthComposite summary : results) {
                    String link = feed.getBaseUrl() + FunctionTagLibrary.getDefaultResourceTabURL() + "?id=" + summary.getId();
                    String availText = res.getMessage("dash.home.ResourceHealth.rss.item.availability", (Object)summary.getAvailabilityType().toString());
                    String alertsText = res.getMessage("dash.home.ResourceHealth.rss.item.alerts", (Object)summary.getAlerts());
                    String typeText = res.getMessage("dash.home.ResourceHealth.rss.item.resourceType", (Object)summary.getTypeName());
                    long now = System.currentTimeMillis();
                    StringBuffer desc = new StringBuffer();
                    desc.append("<table><tr><td align=\"left\">").append(typeText).append("</td></tr>");
                    if (favoriteResourcePreferences.showAvailability) {
                        desc.append("<tr><td align=\"left\">").append(availText).append("</td></tr>");
                    }
                    if (favoriteResourcePreferences.showAlerts) {
                        desc.append("<tr><td align=\"left\">").append(alertsText).append("</td></tr>");
                    }
                    desc.append("</table>");
                    feed.addItem(summary.getName(), link, desc.toString(), now);
                }
            }
            request.setAttribute("rssFeed", (Object)feed);
            return mapping.findForward("rss.feed");
        }
        throw new LoginException("RSS access requires authentication");
    }
}

