/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin;

import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class LargeEnvironmentPreparationUIBean {
    private final Log log = LogFactory.getLog(LargeEnvironmentPreparationUIBean.class);
    public static final String MANAGED_BEAN_NAME = "LargeEnvironmentPreparationUIBean";
    private MeasurementScheduleManagerLocal measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();

    public String disableMeasurementTemplates() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        this.log.warn((Object)(subject.getName() + " has requested to disable measurement templates."));
        try {
            this.measurementScheduleManager.disableAllDefaultCollections(subject);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Collection intervals for all Measurement Templates have been disabled. This means any new resources that will be imported in the future will, by default, not collect measurements. Current resources already in inventory have not been affected.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to disable all measurement templates. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
        }
        return "success";
    }

    public String disableMeasurementSchedules() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        this.log.warn((Object)(subject.getName() + " has requested to disable current measurement schedules."));
        try {
            this.measurementScheduleManager.disableAllSchedules(subject);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Collection intervals for all current resources in inventory have been disabled. This means all resources will no longer collect measurements. Resources that you import into inventory in the future will collect measurements unless you also disabled the templates.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to disable all resource measurement schedules. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
        }
        return "success";
    }
}

