/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.rhq.enterprise.gui.image.chart.SmartLabel;

class SmartLabelMaker {
    private static final SimpleDateFormat DF_SHORT_FULL = new SimpleDateFormat("H:mm");
    private static final SimpleDateFormat DF_SHORT_ABBREV = new SimpleDateFormat(":mm");
    private static final SimpleDateFormat DF_SHORT_CHECKDIFF = new SimpleDateFormat("H");
    private static final SimpleDateFormat DF_MEDIUM_FULL_TOP = new SimpleDateFormat("H:mm");
    private static final SimpleDateFormat DF_MEDIUM_FULL_BOTTOM = new SimpleDateFormat("M/d");
    private static final SimpleDateFormat DF_MEDIUM_ABBREV = new SimpleDateFormat("H:mm");
    private static final SimpleDateFormat DF_MEDIUM_CHECKDIFF = new SimpleDateFormat("d");
    private static final SimpleDateFormat DF_LONG_FULL_TOP = new SimpleDateFormat("M/d");
    private static final SimpleDateFormat DF_LONG_FULL_BOTTOM = new SimpleDateFormat("H:mm");
    private static final SimpleDateFormat DF_LONG_ABBREV_TOP = new SimpleDateFormat("M/d");
    private static final SimpleDateFormat DF_LONG_ABBREV_BOTTOM = new SimpleDateFormat("H:mm");
    private static final SimpleDateFormat DF_LONG_CHECKDIFF = new SimpleDateFormat("d");
    private SimpleDateFormat _fullFormatTop = null;
    private SimpleDateFormat _fullFormatBottom = null;
    private SimpleDateFormat _abbrevFormatTop = null;
    private SimpleDateFormat _abbrevFormatBottom = null;
    private SimpleDateFormat _checkDiff = null;
    private int _labelSpacing = 4;
    private String _lastCheck = "";

    public SmartLabelMaker(long interval) {
        long absInterval = Math.abs(interval);
        if (absInterval < 600000L) {
            this._fullFormatTop = DF_SHORT_FULL;
            this._abbrevFormatTop = DF_SHORT_ABBREV;
            this._checkDiff = DF_SHORT_CHECKDIFF;
            this._labelSpacing = 4;
        } else if (absInterval < 0x6DDD00L) {
            this._fullFormatTop = DF_MEDIUM_FULL_TOP;
            this._fullFormatBottom = DF_MEDIUM_FULL_BOTTOM;
            this._abbrevFormatTop = DF_MEDIUM_ABBREV;
            this._checkDiff = DF_MEDIUM_CHECKDIFF;
            this._labelSpacing = 4;
        } else {
            this._fullFormatTop = DF_LONG_FULL_TOP;
            this._fullFormatBottom = DF_LONG_FULL_BOTTOM;
            this._abbrevFormatTop = DF_LONG_ABBREV_TOP;
            this._abbrevFormatBottom = DF_LONG_ABBREV_BOTTOM;
            this._checkDiff = DF_LONG_CHECKDIFF;
            this._labelSpacing = 4;
        }
    }

    public int getLabelSpacing() {
        return this._labelSpacing;
    }

    public SmartLabel getLabels(boolean forceFullLabel, long absoluteMillis) {
        SmartLabel label = new SmartLabel();
        Date d = new Date(absoluteMillis);
        String check = this._checkDiff.format(d);
        if (forceFullLabel || !check.equals(this._lastCheck)) {
            this._lastCheck = check;
            label.top = this._fullFormatTop.format(d);
            label.bottom = this._fullFormatBottom == null ? "" : this._fullFormatBottom.format(d);
        } else {
            label.top = this._abbrevFormatTop.format(d);
            label.bottom = this._abbrevFormatBottom == null ? "" : this._abbrevFormatBottom.format(d);
        }
        return label;
    }
}

