/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.contextmenu.MenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.MetricMenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.QuickLinksDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.TreeContextMenuBase;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.cluster.ClusterKey;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.html.ContextMenu;
import org.richfaces.component.html.HtmlMenuGroup;
import org.richfaces.component.html.HtmlMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupTreeContextMenuUIBean
extends TreeContextMenuBase {
    private ResourceGroup currentResourceGroup;
    private String currentParentResourceGroupId;
    private List<MenuItemDescriptor> menuItemDescriptorsForView;
    private List<MetricMenuItemDescriptor> metricMenuItemDescriptorsForGraph;
    private List<MenuItemDescriptor> menuItemDescriptorsForOperations;
    private ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
    private ClusterManagerLocal clusterManager = LookupUtil.getClusterManager();
    private OperationManagerLocal operationManager = LookupUtil.getOperationManager();
    private MeasurementDefinitionManagerLocal measurementDefinitionManager = LookupUtil.getMeasurementDefinitionManager();

    protected void init() throws Exception {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String clusterKeyString = FacesContextUtility.getOptionalRequestParameter((String)"contextClusterKey");
        String groupIdString = FacesContextUtility.getOptionalRequestParameter((String)"contextGroupId");
        this.currentParentResourceGroupId = FacesContextUtility.getOptionalRequestParameter((String)"contextParentGroupId");
        this.currentResourceGroup = null;
        if (clusterKeyString != null) {
            ClusterKey key = ClusterKey.valueOf((String)clusterKeyString);
            this.currentResourceGroup = this.clusterManager.createAutoClusterBackingGroup(subject, key, false);
        } else if (groupIdString != null) {
            int groupId = Integer.parseInt(groupIdString);
            this.currentResourceGroup = this.groupManager.getResourceGroupById(subject, groupId, null);
        }
        if (this.currentResourceGroup != null) {
            List definitions = this.measurementDefinitionManager.findMeasurementDefinitionsByResourceType(subject, this.currentResourceGroup.getResourceType().getId(), DataType.MEASUREMENT, null);
            List operations = this.operationManager.findSupportedResourceTypeOperations(subject, this.currentResourceGroup.getResourceType().getId(), false);
            this.menuItemDescriptorsForView = this.createViewMenuItemDescriptors(this.currentResourceGroup, definitions);
            this.metricMenuItemDescriptorsForGraph = this.createGraphMenuItemDescriptors(this.currentResourceGroup, definitions);
            this.menuItemDescriptorsForOperations = this.createOperationMenuItemDescriptors(this.currentResourceGroup.getId(), this.currentParentResourceGroupId, operations);
        } else {
            this.menuItemDescriptorsForView = null;
            this.metricMenuItemDescriptorsForGraph = null;
            this.menuItemDescriptorsForOperations = null;
        }
    }

    protected List<String> getMenuHeaders() {
        return Collections.singletonList(this.currentResourceGroup.getName());
    }

    protected QuickLinksDescriptor getMenuQuickLinks() {
        QuickLinksDescriptor descriptor = new QuickLinksDescriptor();
        descriptor.setMenuItemId("menu_groupQuickLinks_" + this.currentResourceGroup.getId());
        String attributes = "groupId=" + this.currentResourceGroup.getId();
        if (this.currentParentResourceGroupId != null) {
            attributes = attributes + "&parentGroupId=" + this.currentParentResourceGroupId;
        }
        descriptor.setMonitoringUrl("/rhq/group/monitor/graphs.xhtml?" + attributes);
        descriptor.setInventoryUrl("/rhq/group/inventory/view.xhtml?" + attributes);
        descriptor.setAlertsUrl("/rhq/group/alert/listGroupAlertDefinitions.xhtml?" + attributes);
        descriptor.setConfigurationUrl("/rhq/group/configuration/viewCurrent.xhtml?" + attributes);
        descriptor.setOperationUrl("/rhq/group/operation/groupOperationScheduleNew.xhtml?" + attributes);
        descriptor.setEventUrl("/rhq/group/events/history.xhtml?" + attributes);
        return descriptor;
    }

    protected List<MenuItemDescriptor> getViewChartsMenuItems() {
        return this.menuItemDescriptorsForView;
    }

    protected List<MetricMenuItemDescriptor> getGraphToViewMenuItems() {
        return this.metricMenuItemDescriptorsForGraph;
    }

    protected List<MenuItemDescriptor> getOperationsMenuItems() {
        return this.menuItemDescriptorsForOperations;
    }

    protected int getResourceTypeId() {
        return this.currentResourceGroup.getResourceType().getId();
    }

    protected boolean shouldCreateMenu() {
        return this.currentResourceGroup != null && this.currentResourceGroup.getResourceType() != null;
    }

    protected void addAdditionalMenuItems(ContextMenu menu) {
        List resources = null;
        resources = this.currentResourceGroup.getClusterKey() != null ? this.clusterManager.getAutoClusterResources(EnterpriseFacesContextUtility.getSubject(), ClusterKey.valueOf((String)this.currentResourceGroup.getClusterKey())) : this.groupManager.findResourcesForResourceGroup(EnterpriseFacesContextUtility.getSubject(), this.currentResourceGroup.getId(), null);
        HtmlMenuGroup membersMenuItem = new HtmlMenuGroup();
        membersMenuItem.setValue((Object)"Members");
        membersMenuItem.setId("menu_groupMembers_" + this.currentResourceGroup.getId());
        membersMenuItem.setStyle("color: black;");
        for (Resource res : resources) {
            HtmlMenuItem menuItem = new HtmlMenuItem();
            menuItem.setValue((Object)res.getName());
            menuItem.setId("groupMember_" + res.getId());
            String url = "/rhq/resource/summary/overview.xhtml?id=" + res.getId();
            menuItem.setSubmitMode("none");
            menuItem.setOnclick("document.location.href='" + url + "'");
            membersMenuItem.getChildren().add(menuItem);
        }
        menu.getChildren().add(membersMenuItem);
    }

    private List<MetricMenuItemDescriptor> createGraphMenuItemDescriptors(ResourceGroup group, List<MeasurementDefinition> definitions) {
        ArrayList<MetricMenuItemDescriptor> ret = new ArrayList<MetricMenuItemDescriptor>();
        for (MeasurementDefinition definition : definitions) {
            MetricMenuItemDescriptor descriptor = new MetricMenuItemDescriptor();
            this.fillBasicMetricMenuItemDescriptor((MenuItemDescriptor)descriptor, group.getId(), "measurementGraphMenuItem_", definition);
            descriptor.setMetricToken("cg," + group.getId() + "," + definition.getId());
            ret.add(descriptor);
        }
        return ret;
    }

    private List<MenuItemDescriptor> createViewMenuItemDescriptors(ResourceGroup group, List<MeasurementDefinition> definitions) {
        ArrayList<MenuItemDescriptor> ret = new ArrayList<MenuItemDescriptor>();
        for (MeasurementDefinition definition : definitions) {
            MenuItemDescriptor descriptor = new MenuItemDescriptor();
            this.fillBasicMetricMenuItemDescriptor(descriptor, group.getId(), "measurementChartMenuItem_", definition);
            ret.add(descriptor);
        }
        return ret;
    }

    private List<MenuItemDescriptor> createOperationMenuItemDescriptors(int groupId, String parentGroupId, List<OperationDefinition> operations) {
        ArrayList<MenuItemDescriptor> ret = new ArrayList<MenuItemDescriptor>();
        for (OperationDefinition def : operations) {
            MenuItemDescriptor descriptor = new MenuItemDescriptor();
            descriptor.setMenuItemId("operation_" + def.getId());
            descriptor.setName(def.getDisplayName());
            String url = "/rhq/group/operation/groupOperationScheduleNew.xhtml";
            url = url + "?opId=" + def.getId();
            url = url + "&groupId=" + groupId;
            if (parentGroupId != null) {
                url = url + "&parentGroupId=" + parentGroupId;
            }
            descriptor.setUrl(url);
            ret.add(descriptor);
        }
        return ret;
    }

    private void fillBasicMetricMenuItemDescriptor(MenuItemDescriptor descriptor, int groupId, String idPrefix, MeasurementDefinition definition) {
        descriptor.setMenuItemId(idPrefix + definition.getId());
        descriptor.setName(definition.getDisplayName());
        String url = "/resource/common/monitor/Visibility.do";
        url = url + "?mode=chartSingleMetricSingleResource";
        url = url + "&m=" + definition.getId();
        url = url + "&groupId=" + groupId;
        descriptor.setUrl(url);
    }
}

