/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.user;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.enterprise.gui.admin.user.EditPasswordForm;
import org.rhq.enterprise.gui.admin.user.NewAction;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditPasswordAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)NewAction.class.getName());
        EditPasswordForm pForm = (EditPasswordForm)form;
        ActionForward forward = this.checkSubmit(request, mapping, form, "u", (Object)pForm.getId());
        if (forward != null) {
            return forward;
        }
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        int subjectSession = subject.getSessionId();
        Subject userToBeModified = subjectManager.getSubjectById(pForm.getId().intValue());
        String userName = userToBeModified.getName();
        log.debug((Object)("Editing password for user [" + userName + "]"));
        boolean admin = LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_SECURITY);
        boolean isSameUser = subject.getName().equals(userName);
        if (!admin) {
            try {
                int dummySession = subjectManager.login(userName, pForm.getCurrentPassword()).getSessionId();
                subjectManager.logout(dummySession);
                if (isSameUser) {
                    subject = subjectManager.login(userName, pForm.getCurrentPassword());
                }
            }
            catch (LoginException e) {
                RequestUtils.setError((HttpServletRequest)request, (String)"admin.user.error.WrongPassword", (String)"currentPassword");
                return this.returnFailure(request, mapping, "u", (Object)pForm.getId());
            }
        }
        String newPassword = pForm.getNewPassword();
        subjectManager.changePassword(subject, userName, newPassword);
        if (isSameUser) {
            subjectManager.logout(subject.getSessionId().intValue());
        }
        return this.returnSuccess(request, mapping, "u", (Object)pForm.getId());
    }
}

