/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration;

import java.util.Hashtable;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationUIBean {
    protected static final String SUCCESS_OUTCOME = "success";
    protected static final String FAILURE_OUTCOME = "failure";
    protected ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
    private Map<Integer, ConfigurationDefinition> configurationDefinitionMap = new Hashtable();
    private Map<Integer, Configuration> configurationMap = new Hashtable();

    protected AbstractConfigurationUIBean() {
    }

    protected <T> void removeSessionScopedBeanIfInView(String targetViewId, Class<T> clazz) {
        try {
            String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
            if (viewId != null && viewId.equals(targetViewId)) {
                FacesContextUtility.removeSessionScopedBean(clazz);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    protected abstract ConfigurationDefinition lookupConfigurationDefinition();

    protected abstract int getConfigurationDefinitionKey();

    public void setConfigurationDefinition(@NotNull ConfigurationDefinition configurationDefinition) {
        this.configurationDefinitionMap.put(this.getConfigurationDefinitionKey(), configurationDefinition);
    }

    public ConfigurationDefinition getConfigurationDefinition() {
        ConfigurationDefinition configurationDefinition = (ConfigurationDefinition)this.configurationDefinitionMap.get(this.getConfigurationDefinitionKey());
        if (configurationDefinition == null && (configurationDefinition = this.lookupConfigurationDefinition()) != null) {
            this.configurationDefinitionMap.put(this.getConfigurationDefinitionKey(), configurationDefinition);
        }
        return configurationDefinition;
    }

    @Nullable
    protected abstract Configuration lookupConfiguration();

    protected abstract int getConfigurationKey();

    public void setConfiguration(@NotNull Configuration configuration) {
        this.configurationMap.put(this.getConfigurationKey(), configuration);
    }

    public Configuration getConfiguration() {
        Configuration configuration = (Configuration)this.configurationMap.get(this.getConfigurationKey());
        if (configuration == null && (configuration = this.lookupConfiguration()) != null) {
            this.configurationMap.put(this.getConfigurationKey(), configuration);
        }
        return configuration;
    }

    public void clearConfiguration() {
        this.configurationMap.remove(this.getConfigurationKey());
    }

    public boolean isUpdateInProgress() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        int resourceId = EnterpriseFacesContextUtility.getResource().getId();
        return this.configurationManager.isResourceConfigurationUpdateInProgress(subject, resourceId);
    }

    public String getNullConfigurationDefinitionMessage() {
        return "This resource does not expose a configuration.";
    }

    public String getNullConfigurationMessage() {
        return "This resource's configuration has not yet been initialized.";
    }
}

