/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.model.SelectItem;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.gui.configuration.ConfigurationMaskingUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.configuration.AbstractConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNewConfigurationChildResourceUIBean
extends AbstractConfigurationUIBean {
    public static final String MANAGED_BEAN_NAME = "CreateNewConfigurationChildResourceUIBean";
    private static final String OUTCOME_SUCCESS_OR_FAILURE = "successOrFailure";
    private String selectedTemplateName;
    private Map<Integer, ResourceType> resourceTypeMap = new Hashtable();
    private Map<Integer, String> resourceNameMap = new Hashtable();
    private UIInput resourceTypeInput;
    private UIInput selectedTemplateNameInput;

    public String createResource() {
        Subject user = EnterpriseFacesContextUtility.getSubject();
        Configuration pluginConfiguration = this.createPluginConfiguration(user);
        Resource parentResource = EnterpriseFacesContextUtility.getResource();
        Configuration resourceConfiguration = this.getConfiguration();
        ConfigurationMaskingUtility.unmaskConfiguration((Configuration)resourceConfiguration, (ConfigurationDefinition)this.getConfigurationDefinition());
        try {
            ResourceFactoryManagerLocal resourceFactoryManager = LookupUtil.getResourceFactoryManager();
            resourceFactoryManager.createResource(user, parentResource.getId(), this.getResourceTypeId(), this.getResourceName(), pluginConfiguration, resourceConfiguration);
        }
        catch (Exception e) {
            String errorMessages = ThrowableUtil.getAllMessages((Throwable)e);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to send create resource request to agent. Cause: " + errorMessages));
            this.clear();
            return OUTCOME_SUCCESS_OR_FAILURE;
        }
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Create resource request successfully sent to the agent");
        this.clear();
        return OUTCOME_SUCCESS_OR_FAILURE;
    }

    public String selectTemplate() {
        return "success";
    }

    public String cancel() {
        this.clear();
        return "success";
    }

    public String finish() {
        return "success";
    }

    public List<SelectItem> getTemplateNames() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (ConfigurationTemplate template : this.getConfigurationDefinition().getTemplates().values()) {
            StringBuilder label = new StringBuilder(template.getName());
            if (template.getDescription() != null && !template.getDescription().equals("") && !template.getDescription().equals(template.getName())) {
                label.append(" - ").append(template.getDescription());
            }
            SelectItem selectItem = new SelectItem((Object)template.getName(), label.toString());
            selectItems.add(selectItem);
        }
        return selectItems;
    }

    private ResourceType lookupResourceType() {
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceType resourceType = null;
        try {
            resourceType = resourceTypeManager.getResourceTypeById(subject, this.getResourceTypeId());
        }
        catch (ResourceTypeNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return resourceType;
    }

    protected ConfigurationDefinition lookupConfigurationDefinition() {
        Subject user = EnterpriseFacesContextUtility.getSubject();
        ConfigurationDefinition configurationDefinition = this.configurationManager.getResourceConfigurationDefinitionWithTemplatesForResourceType(user, this.getResourceTypeId());
        return configurationDefinition;
    }

    @NotNull
    protected Configuration lookupConfiguration() {
        ConfigurationTemplate resourceConfigTemplate;
        this.selectedTemplateName = this.selectedTemplateNameInput != null ? (String)this.selectedTemplateNameInput.getValue() : null;
        if (this.selectedTemplateName != null && !this.selectedTemplateName.equals("")) {
            resourceConfigTemplate = this.getConfigurationDefinition().getTemplate(this.selectedTemplateName);
            if (resourceConfigTemplate == null) {
                throw new IllegalStateException("A template named '" + this.selectedTemplateName + "' does not exist for " + this.getResourceType() + " resource configurations.");
            }
        } else {
            resourceConfigTemplate = this.getConfigurationDefinition().getDefaultTemplate();
        }
        Configuration resourceConfig = resourceConfigTemplate != null ? resourceConfigTemplate.createConfiguration() : new Configuration();
        ConfigurationUtility.normalizeConfiguration((Configuration)resourceConfig, (ConfigurationDefinition)this.getConfigurationDefinition());
        ConfigurationMaskingUtility.maskConfiguration((Configuration)resourceConfig, (ConfigurationDefinition)this.getConfigurationDefinition());
        return resourceConfig;
    }

    private void clear() {
        this.clearConfiguration();
        this.resourceTypeMap.remove(this.getResourceTypeId());
        this.resourceNameMap.remove(this.getResourceTypeId());
    }

    public ResourceType getResourceType() {
        int resourceTypeId = this.getResourceTypeId();
        if (!this.resourceTypeMap.containsKey(resourceTypeId)) {
            this.resourceTypeMap.put(resourceTypeId, this.lookupResourceType());
        }
        return (ResourceType)this.resourceTypeMap.get(resourceTypeId);
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceTypeMap.put(this.getResourceTypeId(), resourceType);
    }

    public UIInput getResourceTypeInput() {
        return this.resourceTypeInput;
    }

    public void setResourceTypeInput(UIInput resourceTypeInput) {
        this.resourceTypeInput = resourceTypeInput;
    }

    public UIInput getSelectedTemplateNameInput() {
        return this.selectedTemplateNameInput;
    }

    public void setSelectedTemplateNameInput(UIInput selectedTemplateNameInput) {
        this.selectedTemplateNameInput = selectedTemplateNameInput;
    }

    public String getResourceName() {
        return (String)this.resourceNameMap.get(this.getResourceTypeId());
    }

    public void setResourceName(String resourceName) {
        this.resourceNameMap.put(this.getResourceTypeId(), resourceName);
    }

    public String getSelectedTemplateName() {
        if (this.selectedTemplateName == null) {
            ConfigurationTemplate defaultTemplate = this.getConfigurationDefinition().getDefaultTemplate();
            this.selectedTemplateName = defaultTemplate != null ? defaultTemplate.getName() : null;
        }
        return this.selectedTemplateName;
    }

    public void setSelectedTemplateName(String selectedTemplateName) {
        this.selectedTemplateName = selectedTemplateName;
        super.clearConfiguration();
    }

    public String getNullConfigurationDefinitionMessage() {
        return "This resource does not expose a configuration.";
    }

    public String getNullConfigurationMessage() {
        return "Unable to create an initial configuration for resource being added.";
    }

    protected int getConfigurationDefinitionKey() {
        return this.getResourceTypeId();
    }

    protected int getConfigurationKey() {
        return this.getResourceTypeId();
    }

    private int getResourceTypeId() {
        try {
            return EnterpriseFacesContextUtility.getResourceType().getId();
        }
        catch (Exception e) {
            return (Integer)FacesContextUtility.getFacesContext().getExternalContext().getRequestMap().get("type");
        }
    }

    private Configuration createPluginConfiguration(Subject user) {
        ConfigurationDefinition pluginConfigDefinition = this.configurationManager.getPluginConfigurationDefinitionForResourceType(user, this.getResourceTypeId());
        Configuration pluginConfig = null;
        if (pluginConfigDefinition != null) {
            ConfigurationTemplate pluginConfigTemplate = pluginConfigDefinition.getDefaultTemplate();
            pluginConfig = pluginConfigTemplate != null ? pluginConfigTemplate.createConfiguration() : new Configuration();
            ConfigurationUtility.normalizeConfiguration((Configuration)pluginConfig, (ConfigurationDefinition)pluginConfigDefinition);
        }
        return pluginConfig;
    }
}

