/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.calltime.CallTimeDataComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricRange;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsControlForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsControlFormPrepareAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.PerformanceForm;
import org.rhq.enterprise.gui.legacy.util.ChartData;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceFormPrepareAction
extends MetricsControlFormPrepareAction {
    protected static Log log = LogFactory.getLog(PerformanceFormPrepareAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PageList callTimeDataComposites;
        super.execute(mapping, form, request, response);
        MetricRange range = (MetricRange)request.getAttribute("metricRange");
        if (range == null) {
            WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
            MeasurementPreferences preferences = user.getMeasurementPreferences();
            MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
            range = new MetricRange();
            range.setBegin(rangePreferences.begin);
            range.setEnd(rangePreferences.end);
        }
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        Resource resource = (Resource)request.getAttribute("Resource");
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        List callTimeSchedules = scheduleManager.findSchedulesForResourceAndType(subject, resource.getId(), DataType.CALLTIME, null, false);
        PerformanceForm perfForm = (PerformanceForm)form;
        this.prepareForm(request, perfForm, callTimeSchedules);
        MeasurementSchedule selectedSchedule = null;
        if (perfForm.getScheduleId() != null && !perfForm.getScheduleId().equals(PerformanceForm.DEFAULT_SCHEDULE_ID)) {
            for (MeasurementSchedule callTimeSchedule : callTimeSchedules) {
                if (callTimeSchedule.getId() != perfForm.getScheduleId().intValue()) continue;
                selectedSchedule = callTimeSchedule;
            }
        }
        if (selectedSchedule != null) {
            MeasurementDefinition measurementDef = selectedSchedule.getDefinition();
            request.setAttribute("MeasurementDef", (Object)measurementDef);
            CallTimeDataManagerLocal callTimeDataManager = LookupUtil.getCallTimeDataManager();
            PageControl pageControl = WebUtility.getPageControl((ServletRequest)request);
            callTimeDataComposites = callTimeDataManager.findCallTimeDataForResource(subject, selectedSchedule.getId(), range.getBegin().longValue(), range.getEnd().longValue(), pageControl);
        } else {
            callTimeDataComposites = new PageList();
        }
        if (log.isDebugEnabled()) {
            for (CallTimeDataComposite datum : callTimeDataComposites) {
                log.debug((Object)("Call-time datum: " + datum));
            }
        }
        request.setAttribute("PerfSummaries", (Object)callTimeDataComposites);
        if (selectedSchedule != null) {
            ChartData chartData = this.createChartData(callTimeDataComposites, perfForm, selectedSchedule);
            request.getSession().setAttribute("chartData", (Object)chartData);
        }
        return null;
    }

    protected void prepareForm(HttpServletRequest request, PerformanceForm form, List<MeasurementSchedule> schedules) throws IllegalArgumentException {
        if (!form.isAnythingClicked()) {
            form.setLow(PerformanceForm.DEFAULT_LOW);
            form.setAvg(PerformanceForm.DEFAULT_AVG);
            form.setPeak(PerformanceForm.DEFAULT_PEAK);
        }
        PageControl pageControl = WebUtility.getPageControl((ServletRequest)request);
        form.setPn(Integer.valueOf(pageControl.getPageNumber()));
        form.setPs(Integer.valueOf(pageControl.getPageSize()));
        form.setSc(pageControl.getPrimarySortColumn());
        PageOrdering ordering = pageControl.getPrimarySortOrder();
        form.setSo(ordering != null ? ordering.name() : null);
        form.setSchedules(schedules.toArray(new MeasurementSchedule[schedules.size()]));
        form.setMetricCount(Integer.valueOf(schedules.size()));
        if (schedules.size() == 1) {
            form.setScheduleId(Integer.valueOf(schedules.get(0).getId()));
        }
        super.prepareForm(request, (MetricsControlForm)form);
    }

    protected ChartData createChartData(PageList<CallTimeDataComposite> callTimeDataComposites, PerformanceForm form, MeasurementSchedule schedule) {
        ChartData chartData = new ChartData();
        chartData.setSummaries(callTimeDataComposites);
        chartData.setShowLow(form.getLow());
        chartData.setShowAvg(form.getAvg());
        chartData.setShowPeak(form.getPeak());
        chartData.setMeasurementDefinition(schedule.getDefinition());
        return chartData;
    }
}

